<?php

use Illuminate\Support\Facades\Log;
use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumberUtil;
use Illuminate\Support\Facades\DB;

if (!function_exists('is_valid_phone_number')) {
    function is_valid_phone_number($phoneNumber, $countryCode): bool
    {
        $phoneUtil = PhoneNumberUtil::getInstance();

        try {
            $parsedNumber = $phoneUtil->parse($phoneNumber, $countryCode);

            return $phoneUtil->isValidNumber($parsedNumber);
        } catch (NumberParseException $e) {
            Log::error($e);
            return false;
        }
    }
}

if (!function_exists('send_curl_request')) {
    function send_curl_request($url, $payload, $headers = [])
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => $headers,
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        if (!$response) {
            return [];
        }

        return json_decode($response, true);
    }
}

if (!function_exists('send_sms_using')) {
    function send_sms_using($phoneNumber, $textMessage, $api = null): mixed
    {
        return match ($api) {
            'bulksmsbd' => send_bulksmsbd_sms($phoneNumber, $textMessage),
            'd7networks' => send_d7networks_sms($phoneNumber, $textMessage),
            default => null,
        };
    }
}

if (!function_exists('send_d7networks_sms')) {
    function send_d7networks_sms($phoneNumber, $textMessage)
    {
          $settings = DB::table('generalsettings')->first();   
        $token = $settings->d7networks_api_token;
        $apiEndpoint = $settings->d7networks_api_endpoint;
        $message_obj = [
            "channel" => "sms",
            "msg_type" => "text",
            "recipients" => [$phoneNumber],
            "content" => $textMessage,
            "data_coding" => "auto"
        ];
        $payload = json_encode([
            "messages" => [$message_obj]
        ]);
        $headers = [
            'Content-Type: application/json',
            'Accept: application/json',
            'Authorization: Bearer '.$token
        ];

        try {
            $response = send_curl_request($apiEndpoint, $payload, $headers);
            Log::info($response);
            return isset($response['status']) && $response['status'] == 'accepted';
        } catch (Throwable $th) {
            Log::error($th);
            return false;
        }
    }
}

if (!function_exists('send_bulksmsbd_sms')) {
    function send_bulksmsbd_sms($phoneNumber, $textMessage): bool
    {
         $settings = DB::table('generalsettings')->first();   
        $apiKey = $settings->bulksmsbd_api_key;
        $apiEndpoint = $settings->bulksmsbd_api_endpoint;
        $senderId = $settings->bulksmsbd_sender_id;

        $data = [
            "api_key" => $apiKey,
            "senderid" => $senderId,
            "number" => $phoneNumber,
            "message" => $textMessage
        ];

        $headers = [
            'Content-Type: multipart/form-data',
            'Accept: application/json',
        ];

        try {
            $response = send_curl_request($apiEndpoint, $data, $headers);
            Log::info($response, ["bsms gese" => $response]);
            return isset($response['response_code']) && $response['response_code'] == 202;
        } catch (Throwable $th) {
            Log::error($th);
            return false;
        }
    }
}

if (!function_exists('send_sms')) {
    function send_sms($data): void
    {
        $phoneNumber = $data[0];
        $textMessage = $data[1];

        $isBdNumber = is_valid_phone_number($phoneNumber, 'BD');

        if ($isBdNumber) {
            send_sms_using($phoneNumber, $textMessage, 'bulksmsbd');
            return;
        }

        send_sms_using($phoneNumber, $textMessage, 'd7networks');
    }
}
