<?php

namespace App\Http\Controllers\Admin;

use App\Classes\GeniusMailer;
use App\Http\Controllers\Controller;
use App\Models\EmailTemplate;
use App\Models\Generalsetting;
use App\Models\Subscriber;
use App\Models\User;
use Datatables;
use Illuminate\Http\Request;
use App\Mail\BulkEmail;
use Illuminate\Support\Facades\Mail;
use DB;

class EmailController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    //*** JSON Request
    public function datatables()
    {
        $datas = EmailTemplate::orderBy('id', 'desc');
        //--- Integrating This Collection Into Datatables
        return DataTables::of($datas)
            ->editColumn('emailType', function ($data) {
                return ucwords($data->email_type);
            })
            ->addColumn('action', function (EmailTemplate $data) {
                return '<div class="action-list"><a class="btn btn-primary btn-sm btn-rounded" href="' . route('admin.mail.edit', $data->id) . '"> <i class="fas fa-edit"></i>Edit</a></div>';
            })
            ->toJson(); //--- Returning Json Data To Client Side
    }

    public function index()
    {
        return view('admin.email.index');
    }

    public function config()
    {
        return view('admin.email.config');
    }

    public function edit($id)
    {
        $data = EmailTemplate::findOrFail($id);
        return view('admin.email.edit', compact('data'));
    }

    public function groupemail()
    {
        // return config('mail');
        //  $settings = DB::table('generalsettings')->first();
        $config = Generalsetting::findOrFail(1);
        return view('admin.email.group', compact('config'));
    }

    public function groupemailpost_old(Request $request)
    {
        $config = Generalsetting::findOrFail(1);
        if ($request->type == "User") {
            $users = User::whereIsBanned(0)->get();
            //Sending Email To Users
            foreach ($users as $user) {
                if ($config->is_smtp == 1) {
                    $data = [
                        'to' => $user->email,
                        'subject' => $request->subject,
                        'body' => $request->body,
                    ];

                    $mailer = new GeniusMailer();
                    $mailer->sendCustomMail($data);
                } else {
                    $to = $user->email;
                    $subject = $request->subject;
                    $msg = $request->body;
                    $headers = "From: " . $config->from_name . "<" . $config->from_email . ">";
                    mail($to, $subject, $msg, $headers);
                }
            }
            //--- Redirect Section
            $msg = 'Email Sent Successfully.';
            return response()->json($msg);
            //--- Redirect Section Ends
        } else {
            $users = Subscriber::all();
            //Sending Email To Subscribers
            foreach ($users as $user) {
                if ($config->is_smtp == 1) {
                    $data = [
                        'to' => $user->email,
                        'subject' => $request->subject,
                        'body' => $request->body,
                    ];

                    $mailer = new GeniusMailer();
                    $mailer->sendCustomMail($data);
                } else {
                    $to = $user->email;
                    $subject = $request->subject;
                    $msg = $request->body;
                    $headers = "From: " . $config->from_name . "<" . $config->from_email . ">";
                    mail($to, $subject, $msg, $headers);
                }
            }
        }

        //--- Redirect Section
        $msg = 'Email Sent Successfully.';
        return response()->json($msg);
        //--- Redirect Section Ends
    }

    public function groupemailpost(Request $request)
    {
        $config = Generalsetting::findOrFail(1);
        //   MailConfigService::apply();

        if ($request->type === "User") {
            $recipients =  User::whereIsBanned(0)->pluck('email');
        }else if($request->type === "personal"){
            $recipients =  User::where('account_type',$request->type)->whereIsBanned(0)->pluck('email');
        }else if($request->type === "agent"){
            $recipients =  User::where('account_type',$request->type)->whereIsBanned(0)->pluck('email');
        }else if($request->type === "merchant"){
            $recipients =  User::where('account_type',$request->type)->whereIsBanned(0)->pluck('email');
        } else {
            $recipients = Subscriber::pluck('email');
        }
      

        foreach ($recipients as $email) {
            Mail::to($email)->queue(new BulkEmail($request->subject, $request->body));
            sleep(1);
        }


        //--- Redirect Section
        $msg = 'Email Sent Successfully.';
        return response()->json($msg);
        //--- Redirect Section Ends
    }

    public function update(Request $request, $id)
    {
        $data = EmailTemplate::findOrFail($id);
        $input = $request->all();
        $data->update($input);
        //--- Redirect Section
        $msg = 'Data Updated Successfully.' . '<a href="' . route("admin.mail.index") . '">View Template Lists</a>';
        return response()->json($msg);
        //--- Redirect Section Ends
    }
}
