<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AppNotification;
use Carbon\Carbon;
use Datatables;

class NotificationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function index()
    {
        if (request()->ajax()) {
            $query = auth('admin')->user()->notifications()->orderBy('read_at')->latest();
            return Datatables::of($query)
                ->addIndexColumn()
                ->editColumn('data', function (AppNotification $row) {
                    $new = '';
                    if (!$row->read_at) {
                        $new = '<div class="badge badge-success">New</div>';
                    }

                    return "
                        {$row->getMessage()}
                        $new
                    ";
                })
                ->editColumn('created_at', function (AppNotification $row) {
                    return Carbon::parse($row->created_at)?->diffForHumans();
                })
                ->addColumn('action', function (AppNotification $row) {
                    $markAsReadUrl = route('admin.notifications', [
                        "ref" => "notification",
                        "id" => $row->id,
                    ]);
                    $markAsReadBtn = "";
                    if (!$row->read_at) {
                        $markAsReadBtn = "<a href=\"$markAsReadUrl\" class=\"btn btn-primary btn-sm btn-rounded\">Mask as Read</a>";
                    }
                    $goToBtn = "";
                    $goToUrl = $row->getGoto();
                    if ($goToUrl != '#') {
                        $goToBtn = "<a href=\"$goToUrl\" class=\"btn btn-primary btn-sm btn-rounded\">Go to</a>";
                    }
                    $deleteUrl = route('admin.notifications', ['action' => 'delete', 'id' => $row->id]);
                    $deleteBtn = "<a href=\"$deleteUrl\" class=\"btn btn-danger btn-sm btn-rounded\" onclick=\"return confirm('Are you sure to delete the notification?')\">Delete</a>";

                    return "$markAsReadBtn $goToBtn $deleteBtn";
                })
                ->rawColumns(['data', 'action'])
                ->toJson();
        }

        if (request()->has('action') && request()->action == 'delete') {
            auth('admin')->user()->notifications()->where('id', request('id'))->delete();
            return back()->with('success', 'Notification deleted successfully');
        }

        return view('admin.notification.index');
    }
}
