<?php

namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use App\Models\User;
use App\Models\UserDps;
use App\Models\UserFdr;
use App\Models\Currency;
use App\Models\UserLoan;
use App\Models\Withdraw;
use App\Models\Transaction;
use App\Models\WireTransfer;
use App\Models\BalanceTransfer;
use App\Http\Controllers\Controller;

class ReportsController extends Controller
{
    public function profitFromCharge_old()
    {
        if (request()->ajax()) {
            $query = Transaction::query();

            return datatables()->of($query)
                ->addIndexColumn()
                ->filterColumn('customer_name', function ($query, $keyword) {
                    $query->whereHas('user', function ($query) use ($keyword) {
                        $query->where('name', 'like', "%$keyword%");
                    });
                })
                ->editColumn('type', function (Transaction $row) {
                    $allinfo = json_decode($row->all_info, true);
                    if (isset($allinfo['reciver_type'])) {
                        $type = $row->type . ' (' . $allinfo['reciver_type'] . ')';
                    } else {
                        $type =  $row->type;
                    }
                    return $type;
                })
                ->addColumn('customer_name', function (Transaction $row) {
                    return  $row->user->name;;
                })

                ->editColumn('created_at', function (Transaction $row) {
                    return date('d M Y H:i', strtotime($row->created_at));
                })
                ->editColumn('amount', function (Transaction $row) {
                    return number_format(round(floatval($row->amount), 2), 2);
                })
                // ->editColumn('charge', function (Transaction $row) {
                //     return number_format(round(floatval($row->charge), 2), 2);
                // })
                // ->editColumn('txnid', function (Transaction $row) {
                //     return $row->txnid ?? '---';
                // })
                ->addColumn('debit', function (Transaction $row) {;
                    if ($row->type == "Referral Bonus" || $row->type == "Bonus Money") {
                        return number_format(round(floatval($row->amount), 2), 2);
                    } else {
                        return 0;
                    }
                })
                ->addColumn('credit', function (Transaction $row) {
                    return number_format(round(floatval($row->charge), 2), 2);
                })
                ->rawColumns(['customer_name', 'charge', 'amount',  'debit', 'credit', 'all_info'])
                ->toJson();
        }

        return view('admin.reports.profit-from-charge', [
            'from' => request('from', today()->subMonth()->toDateString()),
            'to' => request('to', today()->toDateString())
        ]);
    }

    public function profitFromCharge_old_latest()
    {
        if (request()->ajax()) {
            $query = Transaction::query()
                ->with('user')
                ->when(request('from'), function ($q) {
                    $q->whereDate('created_at', '>=', request('from'));
                })
                ->when(request('to'), function ($q) {
                    $q->whereDate('created_at', '<=', request('to'));
                });

            return datatables()->of($query)
                ->addIndexColumn()
                ->filter(function ($instance) {
                    // GLOBAL SEARCH
                    $searchValue = request('search')['value'] ?? null;
                    if ($searchValue) {
                        $instance->where(function ($q) use ($searchValue) {
                            $q->where('type', 'like', "%{$searchValue}%")
                                ->orWhere('txnid', 'like', "%{$searchValue}%")
                                ->orWhereHas('user', function ($uq) use ($searchValue) {
                                    $uq->where('name', 'like', "%{$searchValue}%");
                                });
                        });
                    }

                    // COLUMN-WISE SEARCH
                    $columns = request('columns', []);
                    if (!empty($columns)) {
                        foreach ($columns as $index => $column) {
                            $value = $column['search']['value'] ?? null;
                            if (!empty($value)) {
                                switch ($index) {
                                    case 1: // Transaction Type
                                        $instance->where('type', 'like', "%{$value}%");
                                        break;
                                    case 2: // Customer Name
                                        $instance->whereHas('user', function ($q) use ($value) {
                                            $q->where('name', 'like', "%{$value}%");
                                        });
                                        break;
                                    case 3: // Txnid
                                        $instance->where('txnid', 'like', "%{$value}%");
                                        break;
                                        // You can add more cases if you want filtering for date, debit, credit, etc.
                                }
                            }
                        }
                    }
                })
                ->editColumn('type', function (Transaction $row) {
                    $allinfo = json_decode($row->all_info, true);
                    return isset($allinfo['reciver_type'])
                        ? $row->type . ' (' . $allinfo['reciver_type'] . ')'
                        : $row->type;
                })
                ->addColumn('customer_name', function (Transaction $row) {
                    //return <a href="route('admin-user-show', $row->id)"> $row->user->name </a> ?? '---';
                    if ($row->user) {
                        return '<a href="' . route('admin-user-show', $row->user->id) . '">' . e($row->user->name) . '</a>';
                    }
                    return '---';
                })
                ->editColumn('created_at', function (Transaction $row) {
                    return date('d M Y H:i', strtotime($row->created_at));
                })
                ->addColumn('debit', function (Transaction $row) {
                    // return '<p class="m-0 text-danger">' . ($row->type == "Referral Bonus" || $row->type == "Bonus Money")
                    //     ? number_format(round(floatval($row->amount), 2), 2)
                    //     : 0   . '</p>';
                    return '<p class="m-0 text-danger">' .
                        (($row->type == "Referral Bonus" || $row->type == "Bonus Money")
                            ? number_format(round(floatval($row->amount), 2), 2)
                            : 0
                        ) .
                        '</p>';
                })
                ->addColumn('credit', function (Transaction $row) {
                    if ($row->type == 'Bank Plan') {
                        return '<p class="m-0 text-success">' . number_format(round(floatval($row->amount), 2), 2) . '</p>';
                    }
                    return '<p class="m-0 text-success">' . number_format(round(floatval($row->charge), 2), 2) . '</p>';;
                })
                ->rawColumns(['customer_name', 'debit', 'credit'])
                ->toJson();
        }

        return view('admin.reports.profit-from-charge', [
            'from' => request('from', today()->subMonth()->toDateString()),
            'to' => request('to', today()->toDateString())
        ]);
    }

    public function profitFromCharge()
    {
        if (request()->ajax()) {
            $query = Transaction::query()
                ->with('user')
                ->when(request('from') && request('to'), function ($q) {
                    $from = Carbon::parse(request('from'))->startOfDay();
                    $to   = Carbon::parse(request('to'))->endOfDay();

                    $q->whereBetween('created_at', [$from, $to]);
                });

            return datatables()->of($query)
                ->addIndexColumn()
                ->filter(function ($instance) {
                    // GLOBAL SEARCH
                    $searchValue = request('search')['value'] ?? null;
                    if ($searchValue) {
                        $instance->where(function ($q) use ($searchValue) {
                            $q->where('type', 'like', "%{$searchValue}%")
                                ->orWhere('txnid', 'like', "%{$searchValue}%")
                                ->orWhereHas('user', function ($uq) use ($searchValue) {
                                    $uq->where('name', 'like', "%{$searchValue}%");
                                });
                        });
                    }

                    // COLUMN-WISE SEARCH
                    $columns = request('columns', []);
                    if (!empty($columns)) {
                        foreach ($columns as $index => $column) {
                            $value = $column['search']['value'] ?? null;
                            if (!empty($value)) {
                                switch ($index) {
                                    case 1:
                                        $searchValue = $value;
                                        $types = preg_split('/\|/', $searchValue); // split by pipe for regex
                                        $instance->where(function ($q) use ($types) {
                                            foreach ($types as $type) {
                                                $q->orWhere('type', 'like', "%{$type}%");
                                            }
                                        });
                                        break;
                                    case 2: // Customer Name
                                        $instance->whereHas('user', function ($q) use ($value) {
                                            $q->where('name', 'like', "%{$value}%");
                                        });
                                        break;
                                    case 3: // Txnid
                                        $instance->where('txnid', 'like', "%{$value}%");
                                        break;
                                }
                            }
                        }
                    }
                })
                ->editColumn('type', function (Transaction $row) {
                    $allinfo = json_decode($row->all_info, true);

                    if (
                        empty($allinfo) ||
                        !isset($allinfo['reciver_type']) ||
                        $allinfo['reciver_type'] === 'Nan' ||
                        is_null($allinfo['reciver_type'])
                    ) {
                        return $row->type;
                    }

                    return $row->type . ' (' . e($allinfo['reciver_type']) . ')';
                })

                ->addColumn('customer_name', function (Transaction $row) {
                    if ($row->user) {
                        return '<a href="' . route('admin-user-show', $row->user->id) . '">' . e($row->user->name) . '</a>';
                    }
                    return '---';
                })
                ->editColumn('created_at', function (Transaction $row) {
                    return date('d M Y H:i', strtotime($row->created_at));
                })
                ->addColumn('debit', function (Transaction $row) {
                    return '<p class="m-0 text-danger">' .
                        (($row->type == "Referral Bonus" || $row->type == "Bonus Money")
                            ? number_format(round(floatval($row->amount), 2), 2)
                            : 0
                        ) .
                        '</p>';
                })
                ->addColumn('credit', function (Transaction $row) {
                    if ($row->type == 'Bank Plan') {
                        return '<p class="m-0 text-success">' . number_format(round(floatval($row->amount), 2), 2) . '</p>';
                    }

                    if (($row->type == 'Deposit' && $row->profit == 'minus') || ($row->type == 'Withdraw' && $row->profit == 'plus') || ($row->type == 'Withdraw Refund' && $row->profit == 'plus')) {
                        return '<p class="m-0 text-success">' . number_format(round(floatval(- $row->charge), 2), 2) . '</p>';
                    }
                    if (($row->type == 'Deposit Refund' && $row->profit == 'minus')) {
                        return '<p class="m-0 text-success">' . number_format(round(floatval(- $row->charge), 2), 2) . '</p>';
                    }
                    if ((str_contains($row->type, 'Send Money') && $row->profit == 'plus')) {
                        return '<p class="m-0 text-success">' . number_format(round(floatval(- $row->charge), 2), 2) . '</p>';
                    }
                    if ((str_contains($row->type, 'Wire Transfer') && $row->profit == 'plus')) {
                        return '<p class="m-0 text-success">' . number_format(round(floatval(- $row->charge), 2), 2) . '</p>';
                    }
                    if ($row->type == 'Wire Transfer Return' && $row->profit == 'minus') {
                        return '<p class="m-0 text-success">' . number_format(round(floatval(- $row->charge), 2), 2) . '</p>';
                    }
                    return '<p class="m-0 text-success">' . number_format(round(floatval($row->charge), 2), 2) . '</p>';
                })
                ->rawColumns(['customer_name', 'debit', 'credit'])
                ->toJson();
        }

        return view('admin.reports.profit-from-charge', [
            'from' => request('from', today()->subMonth()->toDateString()),
            'to' => request('to', today()->toDateString())
        ]);
    }

    public function balanceReport(){
        try {
            $data['currency'] = Currency::whereIsDefault(1)->first();
            $data['usersTotalBalance'] = User::sum('balance');
            $data['dpsamount'] = UserDps::where('status', 1)->sum('deposit_amount');
            $data['fdramount'] = UserFdr::where('status', 1)->sum('amount');
            $data['withdrawPendingAmount'] = Withdraw::whereStatus('pending')->sum('amount');
            $data['loanamount'] = UserLoan::where('status', 1)->sum('loan_amount');
            $data['otherBankPending'] = BalanceTransfer::whereType('other')->whereNotIn('status', [1, 2])->sum('amount');
            $data['wireTransferPending'] = WireTransfer::whereNotIn('status', [1, 2])->sum('amount');
            $data['bonusPointAmount'] = User::sum('bonus_point');

            return view('admin.reports.balance-report',$data);
        } catch (\Exception $e) {
            dd($e);
        }
    }
}
