<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Models\ProductClick;
use App\Models\Seotool;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SeoToolController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function analytics()
    {
        $tool = Seotool::find(1);
        return view('admin.seotool.googleanalytics', compact('tool'));
    }

    public function analyticsupdate(Request $request)
    {

        $tool = Seotool::findOrFail(1);

        if ($file = $request->file('logo')) {
            $name = Str::random(8) . time() . '.' . $file->getClientOriginalExtension();

            // Move file to public/assets/images
            $file->move(public_path('assets/images'), $name);

            // Delete old logo if exists
            if ($tool->logo && file_exists(public_path('assets/images/' . $tool->logo))) {
                unlink(public_path('assets/images/' . $tool->logo));
            }

            $tool->logo = $name;
        }

        // update other fields if needed
        $tool->fill($request->except('logo'));
        $tool->save();

        $msg = 'Data Updated Successfully.';
        return response()->json($msg);
    }

    public function keywords()
    {
        $tool = Seotool::find(1);
        return view('admin.seotool.meta-keywords', compact('tool'));
    }

    public function keywordsupdate(Request $request)
    {
        $tool = Seotool::findOrFail(1);

        //    dd($request);
        //     if ($file = $request->file('logo')) {
        //         $name = Str::random(8) . time() . '.' . $file->getClientOriginalExtension();
        //         //  dd ($name);
        //         $file->move('assets/images', $name);
        //         if ($tool->logo != null) {
        //             if (file_exists(public_path() . '/assets/images' . $tool->logo)) {
        //                 unlink(public_path() . '/assets/images' . $tool->logo);
        //             }
        //         }
        //         $request['logo'] = $name;
        //     } else {
        //         $request['logo'] = $tool->logo;
        //     }

        $tool->update($request->all());
        $msg = 'Data Updated Successfully.';
        return response()->json($msg);
    }
}
