<?php

namespace App\Http\Controllers\Admin;

use PDF;
use Datatables;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Currency;
use App\Models\Transaction;
use App\Models\WireTransfer;
use Illuminate\Http\Request;
use App\Classes\GeniusMailer;
use App\Models\Generalsetting;
use App\Models\WireTransferBank;
use App\Http\Controllers\Controller;
use App\Models\Country;
use Illuminate\Support\Facades\Auth;

class WireTransferController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function datatables(Request $request)
    {
        $datas = WireTransfer::with('user', 'bank', 'lastHistory')
           ->when(true, function ($query) use ($request) {
                $bank     = $request->bank;
                $status   = $request->status;
                $country  = $request->country;

                if ($bank && $status !== null && $status !== '' && $country) {
                    $query->where('wire_transfer_bank_id', $bank)
                        ->where('status', $status)
                        ->where('country', 'like', "%{$country}%");
                }elseif ($bank && $status !== null && $status !== '') {
                    $query->where('wire_transfer_bank_id', $bank)
                        ->where('status', $status);
                }elseif ($bank && $country) {
                    $query->where('wire_transfer_bank_id', $bank)
                        ->where('country', 'like', "%{$country}%");
                }elseif ($status !== null && $status !== '' && $country) {
                    $query->where('status', $status)
                        ->where('country', 'like', "%{$country}%");
                }elseif ($bank) {
                    $query->where('wire_transfer_bank_id', $bank);
                }elseif ($status !== null && $status !== '') {
                    $query->where('status', $status);
                }elseif ($country) {
                    $query->where('country', 'like', "%{$country}%");
                }
            })
        ->orderBy('id', 'desc');

        return Datatables::of($datas)
            ->addColumn('checkbox', function (WireTransfer $data) {
                return '<input type="checkbox" class="row-checkbox" value="' . $data->id . '">';
            })
            ->editColumn('status_last_history', function ($data) {
                if ($data->lastHistory) {
                    $name = e($data->lastHistory->admin->name);
                    $time = $data->lastHistory->created_at;
                    return "{$name}<br><small>{$time}</small>";
                }
            })
            ->addColumn('user_name', function (WireTransfer $data) {
                return $data->user->name;
            })
            ->addColumn('acc', function (WireTransfer $data) {
                return $data->user->account_number;
            })
            ->addColumn('acc_name', function (WireTransfer $data) {
                return $data->account_holder_name;
            })
            ->editColumn('wire_transfer_bank_id', function (WireTransfer $data) {
                return $data->bank->title;
            })
            ->editColumn('user_id', function (WireTransfer $data) {
                $data = User::whereId($data->user_id)->first();
                if ($data) {
                    return '<div>
                                            <span>'.$data->name.' '.$data->last_name.'</span>
                                            <p>'.$data->account_number.'</p>
                                    </div>';
                } else {
                    return $data = '';
                }
            })
            ->editColumn('account_number', function (WireTransfer $data) {

                return '<div>
                                        <span>'.$data->account_holder_name.'</span>
                                        <p>'.$data->account_number.'</p>
                                </div>';

            })
            ->editColumn('amount', function (WireTransfer $data) {
                $curr = Currency::where('is_default', '=', 1)->first();
                return $curr->sign.$data->amount;
            })
            ->editColumn('charge_amount', function (WireTransfer $data) {
                $curr = Currency::where('is_default', '=', 1)->first();
                return $curr->sign.$data->charge;
            })
            ->editColumn('status', function (WireTransfer $data) {
                if ($data->status == 1) {
                    $status = __('Completed');
                } else if ($data->status == 2) {
                    $status = __('Rejected');
                }else if ($data->status == 3) {
                    $status = __('Processing');
                }else if ($data->status == 4) {
                    $status = __('Hold');
                } else {
                    $status = __('Pending');
                }

                if ($data->status == 1) {
                    $status_sign = 'success';
                } else if ($data->status == 2) {
                    $status_sign = 'danger';
                } else {
                    $status_sign = 'warning';
                }


                return '<div class="btn-group mb-1">
                                <button type="button" class="btn btn-'.$status_sign.' btn-sm btn-rounded dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                  '.$status.'
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                  <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'.route('admin.wire.transfer.status', ['id1' => $data->id, 'id2' => 0]).'">'.__("Pending").'</a>
                                  <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'.route('admin.wire.transfer.status', ['id1' => $data->id, 'id2' => 1]).'">'.__("Completed").'</a>
                                  <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'.route('admin.wire.transfer.status', ['id1' => $data->id, 'id2' => 3]).'">'.__("Processing").'</a>
                                  <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'.route('admin.wire.transfer.status', ['id1' => $data->id, 'id2' => 4]).'">'.__("Hold").'</a>
                                  <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'.route('admin.wire.transfer.status', ['id1' => $data->id, 'id2' => 2]).'">'.__("Rejected").'</a>
                                </div>
                              </div>';
            })
            ->addColumn('action', function (WireTransfer $data) {

                return '<div class="btn-group mb-1">
                                  <button type="button" class="btn btn-primary btn-sm btn-rounded dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    '.'Actions'.'
                                  </button>
                                  <div class="dropdown-menu" x-placement="bottom-start">
                                    <a href="'.route('admin.wire.transfer.show', $data->id).'"  class="dropdown-item">'.__("Details").'</a>
                                  </div>
                                </div>';

            })
            ->rawColumns(['status_last_history', 'checkbox', 'wire_transfer_bank_id', 'user_id', 'account_number', 'amount', 'status', 'action'])
            ->toJson();
    }

    public function index()
    {
        $banks = WireTransferBank::where('status', 1)->get();
        $countries = Country::get();
        return view('admin.wiretransfers.index', compact('banks', 'countries'));
    }

    public function show($id)
    {
        $data = WireTransfer::with('histories')->whereId($id)->first();
        return view('admin.wiretransfers.show', compact('data'));
    }

    public function status($id1, $id2)
    {
        $data = WireTransfer::findOrFail($id1);


        $user = User::findOrFail($data->user_id);
        $authUser =  Auth::guard('admin')->user(); // Logged-in admin or user

        // Check role-based permission
        if (!$authUser->IsSuper() && ($data->status == 1 || $data->status == 2)) {
            $now = Carbon::now();
              $lastUpdate = Carbon::parse($data->updated_at);

              $diff = $lastUpdate->diffInMinutes($now, false);
            if ($diff > 60) {
              //   dd("You do not have permission to change this status.");
                return response()->json( 'You can no longer update this status. 60-minute window has passed.'
                , 200);
            }
        }

        if ($data->status == 0 && $id2 == 0) {
            $msg = 'Already Pending';
            return response()->json($msg);
        }
        if ($data->status == 1 && $id2 == 1) {
            $msg = 'Already Completed';
            return response()->json($msg);
        }
        if ($data->status == 2 && $id2 == 2) {
            $msg = 'Already Rejected';
            return response()->json($msg);
        }
        if ($data->status == 3 && $id2 == 3) {
            $msg = 'Already Processing';
            return response()->json($msg);
        }
        if ($data->status == 4 && $id2 == 4) {
            $msg = 'Already Hold';
            return response()->json($msg);
        }
        statusHistory($data->id, 'wire_transfer', $data->status, $id2);

        if($data->status == 1){
            notifyUser($user->id, 'Wire Transfer Accepted',  'user.wire.transfer.index', $data->id);

            $gs = Generalsetting::first();
            if ($gs->is_smtp == 1) {
                $emailData = [
                    'to' => $data->user->email,
                    'type' => "wire transfer",
                    'cname' => $data->user->name . '' . $data->user->last_name,
                    'oamount' => $data->amount,
                    'aname' => "",
                    'aemail' => "",
                    'wtitle' => "",
                ];

                $mailer = new GeniusMailer();
                $mailer->sendAutoMail($emailData);
            } else {
                $to = $data->user->email;
                $subject = " Wire Transfer Confirmed.";
                $msg = "Hello " . $data->user->name . '' . $data->user->last_name . "!\nWire Transfer Confirmed.\nThank you.";
                $headers = "From: " . $gs->from_name . "<" . $gs->from_email . ">";
                mail($to, $subject, $msg, $headers);
            }
        }

        if ($data->status == 2 && ($id2 == 0 || $id2 == 1|| $id2 == 3 || $id2 == 4)) {
            if ($user) {
                $finalAmount = $data->amount + $data->charge;
                if ($user->balance < $finalAmount) {
                    $msg = __('User has insufficient balance to revert the rejected transfer.');
                    return response()->json($msg);
                }

                $user->decrement('balance', $finalAmount);


                // $otherBank = OtherBank::whereId($data->other_bank_id)->first();
                // $allinfo = [
                //     'sender_type' =>  "Revert Rejected",
                //     'reciver_type' => $user->account_type ,
                //     "fixed_charge_amount" => $otherBank->fixed_charge,
                //     "percent_charge" => $otherBank->percent_charge ?? 0,
                //     "percent_charge_amount" => ($data->amount / 100) * $otherBank->percent_charge,
                // ];

                //trantion added
                $trans = new Transaction();
                $trans->email = $user->email;
                $trans->amount = $data->amount;
                $trans->type = "Wire Transfer Revert Rejected";
                $trans->profit = "minus";
                $trans->txnid = $data->transaction_no;
                $trans->user_id = $user->id;
                // $trans->sender_id = $user->id;
                $trans->charge = $data->charge;
                $trans->user_available_balance = $user->balance;
                $trans->save();

                notifyUser($user->id, 'Wire Transfer Revert Rejected',  'tranfer.logs.index', $data->id);
            }
        }elseif($id2 == 2) {
            $user = User::whereId($data->user_id)->first();
            if ($user) {
                $amount = $data->amount + $data->charge;
                $user->increment('balance', $amount);

                $trans = new Transaction();
                $trans->email = $user->email;
                $trans->amount = $data->amount;
                $trans->type = "Wire Transfer Return";
                $trans->profit = "minus";
                $trans->txnid = $data->transaction_no;
                $trans->user_id = $user->id;
                $trans->receiver_id = 0;
                $trans->charge = $data->charge;
                $trans->user_available_balance = $user->balance;
                $trans->receiver_available_balance = 0;
                $trans->save();

                notifyUser($user->id, 'Wire Transfer Rejected',  'user.wire.transfer.index', $data->id);
            }
        }

        $data->status = $id2;
        $data->update();

        $msg = 'Data Updated Successfully.';
        return response()->json($msg);
    }

    public function pdfprint(Request $request)
    {
        $gs = Generalsetting::first();
        $ids = $request->input('ids');
        $curr = Currency::where('is_default', '=', 1)->first();
        $data = [
            'title' => $gs->title,
            'date' => date('Y-m-d'),
            'currency' => $curr,
        ];

        if ($ids) {
            $data['wire_transfers'] = WireTransfer::with('bank', 'user')
                ->whereIn('id', $ids)
                ->orderBy('id', 'desc')
                ->get();
        } else {
            $data['wire_transfers'] = WireTransfer::with('bank', 'user')
                ->orderBy('id', 'desc')
                ->get();
        }



        $pdf = PDF::loadView('admin.user.wireTransferPdf', $data);

        return $pdf->stream(uniqid('withdraw-') . '.pdf');
    }

    public function bulkChangeStatus(Request $request)
    {
        $statusId = $request->status;
        $updatedCount = 0;
        $skippedCount = 0;
        $messages = [];

        $authUser = Auth::guard('admin')->user(); // Logged-in admin

        foreach ($request->ids as $id1) {
            $data = WireTransfer::find($id1);
            if (!$data) continue;

            if ($data->status == 0 && $statusId == 0) {
                $messages[] = "Transaction {$data->transaction_no} already Pending.";
                continue;
            }
            if ($data->status == 1 && $statusId == 1) {
                $messages[] = "Transaction {$data->transaction_no} already Completed.";
                continue;
            }
            if ($data->status == 2 && $statusId == 2) {
                $messages[] = "Transaction {$data->transaction_no} already Rejected.";
                continue;
            }
            if ($data->status == 3 && $statusId == 3) {
                $messages[] = "Transaction {$data->transaction_no} already Processing.";
                continue;
            }
            if ($data->status == 4 && $statusId == 4) {
                $messages[] = "Transaction {$data->transaction_no} already Hold.";
                continue;
            }

            if (!$authUser->IsSuper() && ($data->status == 1 || $data->status == 2)) {
                $now = Carbon::now();
                $lastUpdate = Carbon::parse($data->updated_at);
                $diff = $lastUpdate->diffInMinutes($now, false);

                if ($diff > 60) {
                    $skippedCount++;
                    $messages[] = "Transaction {$data->transaction_no} skipped — 60-minute window passed.";
                    continue; // Skip updating this record
                }
            }

            statusHistory($data->id, 'wire_transfer', $data->status, $statusId);

            $data->status = $statusId;
            $data->update();

            if ($statusId == 2) {
                $user = User::find($data->user_id);
                if ($user) {
                    $amount = $data->amount + $data->charge;
                    $user->increment('balance', $amount);

                    $trans = new Transaction();
                    $trans->email = $user->email;
                    $trans->amount = $data->amount;
                    $trans->type = "Wire Transfer Return";
                    $trans->profit = "plus";
                    $trans->txnid = $data->transaction_no;
                    $trans->user_id = $user->id;
                    $trans->receiver_id = 0;
                    $trans->charge = $data->charge;
                    $trans->user_available_balance = $user->balance;
                    $trans->receiver_available_balance = 0;
                    $trans->save();
                }
            }

            $updatedCount++;
        }

        $summaryMsg = "{$updatedCount} record(s) updated successfully.";
        if ($skippedCount > 0) {
            $summaryMsg .= " {$skippedCount} record(s) skipped due to 60-minute limit.";
        }

        return response()->json([
            'message' => $summaryMsg,
            'notes' => $messages,
        ]);
    }
}
