<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\KYCResource;
use App\Models\KycForm;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class KYCController extends Controller
{
    public function kycform()
    {
        try {
            $userType = 'user';
            $data = KycForm::where('user_type', $userType == 'user' ? 1 : 2)->get();

            return response()->json(['status' => true, 'data' => KYCResource::collection($data), 'error' => []]);
        } catch (Exception $e) {
            return response()->json(['status' => true, 'data' => [], 'error' => ['message' => $e->getMessage()]]);
        }
    }

    public function store(Request $request)
    {
        $userType = 'user';
        $userForms = KycForm::where('user_type', $userType == 'user' ? 1 : 2)->get();

        $requireInformations = [];
        if ($userForms) {
            foreach ($userForms as $key => $value) {
                if ($value->type == 1) {
                    $requireInformations['text'][$key] = strtolower(str_replace(' ', '_', $value->label));
                } else if ($value->type == 3) {
                    $requireInformations['textarea'][$key] = strtolower(str_replace(' ', '_', $value->label));
                } else {
                    $requireInformations['file'][$key] = strtolower(str_replace(' ', '_', $value->label));
                }
            }
        }


        $details = [];
        foreach ($requireInformations as $key => $infos) {
            foreach ($infos as $index => $info) {

                if ($request->has($info)) {
                    if ($request->hasFile($info)) {
                        if ($file = $request->file($info)) {
                            $name = Str::random(8).time().'.'.$file->getClientOriginalExtension();
                            $file->move('assets/images', $name);
                            $details[$info] = [$name, $key];
                        }
                    } else {
                        $details[$info] = [$request->$info, $key];
                    }
                }
            }
        }

        $user = auth()->user();
        if (!empty($details)) {
            $user->kyc_info = json_encode($details, true);
        }
        $user->save();

        return response()->json('KYC submitted successfully');
    }
}
