<?php

namespace App\Http\Controllers\Deposit;

use App\Classes\GeniusMailer;
use App\Http\Controllers\Controller;
use App\Models\Currency;
use App\Models\Deposit;
use App\Models\Transaction;
use App\Models\Generalsetting;
use App\Models\PaymentGateway;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;

class ManualController extends Controller
{
    public function store(Request $request)
    {
      // dd($request);
        $gateway = PaymentGateway::query()
            ->whereType('manual')
            ->whereId($request->gateway_id)
            ->first();

        $gatewayIds = array_filter(json_decode($gateway->currency_id, true));
        $curr = Currency::whereIn('id', $gatewayIds)->pluck('name')->all();

        $currency = Currency::where('id', $request->currency_id)->first();

        if (!in_array($currency->name, $curr)) {
            return redirect()->back()->with(['unsuccess' => "Please select $curr[0] currency for $gateway->title deposit."]);
        }

        $amountToAdd = $request->amount / $gateway->receiving_rate;

        // dd($amountToAdd);
        $depositNumber = Str::random(12);

        $additional = [];
        foreach ($request->additional ?? [] as $key => $value) {
            $keySlug = Str::slug($key, '_');
            if ($request->hasFile('additional.'.$key)) {
                /* @var UploadedFile $value */
                $fileName = Str::slug(uniqid('', true)."_".$depositNumber, "_");
                $fileName = "$fileName.{$value->getClientOriginalExtension()}";
                //  if (str_starts_with($value->getClientMimeType(), 'image/')) {
                //      storeScaleDownImage($value, 'images/deposits', $fileName);
                //  } else {
                     $value->storeAs('images/deposits', $fileName, 'assets');
               //  }
                $additional[$keySlug] = ['file' => $fileName];
                continue;
            }
            if (!empty($value)) {
                $additional[$keySlug] = ['value' => $value];
            }
        }

        $deposit = new Deposit();
        $deposit['deposit_number'] = $depositNumber;
        $deposit['user_id'] = auth()->id();
        $deposit['currency_id'] = $request->currency_id;
        $deposit['amount'] = $amountToAdd ;
        $deposit['method'] = $request->get('method');
        $deposit['txnid'] = $request->txn_id4;
        $deposit['status'] = "pending";
        $deposit['gateway_id'] = $request->gateway_id;
        $deposit['rate'] = $gateway->receiving_rate;
        $deposit['additional_data'] = $additional;
        $deposit['charge'] = $request->charge / $gateway->receiving_rate;

        $deposit->save();


           

        $gs = Generalsetting::findOrFail(1);
        $user = auth()->user();
                //      $trans = new Transaction();
                // $trans->email = $user->email;
                // $trans->amount = $amountToAdd;
                // $trans->type = "Deposit";
                // $trans->profit = "plus";
                // $trans->txnid = $deposit->deposit_number;
                // $trans->charge = $request->charge;
                // $trans->user_id = $user->id;
                //  $trans->user_available_balance = $user->balance;
                // $trans->save();
        if ($gs->is_smtp == 1) {
            $data = [
                'to' => $user->email,
                'type' => "Deposit",
                'cname' => $user->name,
                'oamount' => $amountToAdd,
                'aname' => "",
                'aemail' => "",
                'wtitle' => "",
            ];

            $mailer = new GeniusMailer();
            $mailer->sendAutoMail($data);
        } else {
            $to = $user->email;
            $subject = " You have deposited successfully.";
            $msg = "Hello ".$user->name."!\nYou have invested successfully.\nThank you.";
            $headers = "From: ".$gs->from_name." <".$gs->from_email.">";
            mail($to, $subject, $msg, $headers);
        }

        return redirect()->route('user.deposit.create')->with('success', 'Deposit amount '.$request->amount.' ('.$request->currency_code.') successfully!');
    }
}
