<?php

namespace App\Http\Controllers\Deposit;

use App\Classes\GeniusMailer;
use App\Http\Controllers\Controller;
use App\Models\Currency;
use App\Models\Deposit;
use App\Models\Generalsetting;
use App\Models\PaymentGateway;
use App\Models\Transaction as AppTransaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Omnipay\Omnipay;

class PaypalController extends Controller
{
    private $_api_context;
    public $support_currencies;
    public $gateway;

    public function __construct()
    {
        $data = PaymentGateway::whereKeyword('paypal')->first();
        $paydata = $data->convertAutoData();
        $this->support_currencies = ['USD', 'EUR'];

        $this->gateway = Omnipay::create('PayPal_Rest');
        $this->gateway->setClientId($paydata['client_id']);
        $this->gateway->setSecret($paydata['client_secret']);
        $this->gateway->setTestMode(true);
    }

    public function store(Request $request)
    {

      //  dd($request);
        if (!in_array($request->currency_code, $this->support_currencies)) {
            return redirect()->back()->with('warning', 'Please Select USD Or EUR Currency For Paypal.');
        }

        $settings = Generalsetting::findOrFail(1);
        $deposit = new Deposit();
        //$cancel_url = action('Deposit\PaypalController@cancle');
        //$notify_url = action('Deposit\PaypalController@notify');

        $cancel_url = route('deposit.paypal.cancle');
        $notify_url = route('deposit.paypal.notify');

        $item_name = $settings->title." Deposit";
        $item_number = Str::random(12);
     //   $amount = $request->amount;
            //  $item_amount = $request->amount / $currency->value;

        $currency = Currency::whereId($request->currency_id)->first();
        $amountToAdd = $request->amount / $currency->value;

        $deposit['user_id'] = auth()->user()->id;
        $deposit['currency_id'] = $request->currency_id;
        $deposit['amount'] = $amountToAdd;
        $deposit['method'] = $request->get('method');
        $deposit['deposit_number'] = $item_number;
        $deposit['charge'] = $request->charge / $currency->value;
        $deposit['status'] = "pending";
        $deposit['gateway_id'] = $request->gateway_id;

        $deposit->save();

        Session::put('deposit_data', $request->all());
        Session::put('deposit_number', $item_number);
        try {
            $response = $this->gateway->purchase(array(
                'amount' => $amountToAdd,
                'currency' => $request->currency_code,
                'returnUrl' => $notify_url,
                'cancelUrl' => $cancel_url,
            ))->send();

            if ($response->isRedirect()) {

                $item_number = Str::random(4).time();
                if ($response->redirect()) {
                    /** redirect to paypal **/
                    return redirect($response->redirect());

                }
            } else {
                return redirect()->back()->with('unsuccess', $response->getMessage());

            }
        } catch (\Throwable $th) {

            return redirect()->back()->with('unsuccess', $response->getMessage());
        }

    }

    public function notify(Request $request)
    {

        $responseData = $request->all();

        if (empty($responseData['PayerID']) || empty($responseData['token'])) {
            return redirect()->back()->with('error', 'Payment Failed');
        }

        $transaction = $this->gateway->completePurchase(array(
            'payer_id' => $responseData['PayerID'],
            'transactionReference' => $responseData['paymentId'],
        ));

        $user = auth()->user();
        $deposit_data = Session::get('deposit_data');

        $response = $transaction->send();

        $deposit_number = Session::get('deposit_number');

        if ($response->isSuccessful()) {

            $deposit = Deposit::where('deposit_number', $deposit_number)->where('status', 'pending')->first();
            $deposit->txnid = $response->getData()['transactions'][0]['related_resources'][0]['sale']['id'];

            $deposit->update();

            $gs = Generalsetting::findOrFail(1);

            if ($gs->is_smtp == 1) {
                $data = [
                    'to' => $user->email,
                    'type' => "Deposit",
                    'cname' => $user->name,
                    'oamount' => $deposit->amount,
                    'aname' => "",
                    'aemail' => "",
                    'wtitle' => "",
                ];

                $mailer = new GeniusMailer();
                $mailer->sendAutoMail($data);
            } else {
                $to = $user->email;
                $subject = " You have deposited successfully.";
                $msg = "Hello ".$user->name."!\nYou have invested successfully.\nThank you.";
                $headers = "From: ".$gs->from_name."<".$gs->from_email.">";
                mail($to, $subject, $msg, $headers);
            }
            $deposit->status = "complete";
            $deposit->save();

            $user->balance += $deposit->amount;
            $user->balance -= $deposit->charge;
            $user->save();

            $fund = PaymentGateway::find($deposit->gateway_id);
            $fund->fund_available += $deposit->amount;
            $fund->save();

            $trans = new AppTransaction();
            $trans->email = $user->email;
            $trans->amount = $deposit->amount;
            $trans->type = "Deposit";
            $trans->profit = "plus";
            $trans->txnid = $deposit->deposit_number;
            $trans->user_id = $user->id;
            $trans->charge = $deposit->charge;
             $trans->user_available_balance = $user->balance;
            $trans->save();

            Session::forget('deposit_data');
            Session::forget('deposit_number');

            return redirect()->route('user.deposit.create')->with('success', 'Deposit amount '.$deposit->amount.' (USD) successfully!');

        } else {
            return redirect()->back()->with('error', __('Payment failed'));
        }
    }
}
