<?php

namespace App\Http\Controllers\Subscription;

use App\Http\Controllers\Controller;
use App\Models\BankPlan;
use App\Models\User;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SubscriptionController extends Controller
{
    public function store(Request $request)
    {
        $user = User::findorFail(auth()->id());
        if ($user) {
            $bankplan = BankPlan::whereId($request->bank_plan_id)->first();

            if ($user->bank_plan_id == $bankplan->id && $user->plan_end_date && $user->plan_end_date > now()) {
                return redirect()->back()->with('message', 'You already have this plan running. Please wait until it expires before purchasing again otherwise buy another plan');
            }
            

            if($user->balance < $bankplan->amount){
                return redirect()->back()->with('message', 'You don\'t have sufficient balance to subscribe to this plan');
            }


            $user->balance = $user->balance - $bankplan->amount;
            $user->bank_plan_id = $bankplan->id;
            $user->plan_end_date = now()->addDays((float)$bankplan->days);
            $user->update();

            if($bankplan->amount > 0){
                $txnid = Str::random(4) . time();
                $trans = new Transaction();
                $trans->email = $user->email;
                $trans->amount = $bankplan->amount;
                $trans->type = "Bank Plan";
                $trans->profit = "plus";
                $trans->txnid = $txnid;
                $trans->user_id = $user->id;
                // $trans->receiver_id = $receiver->id;
                $trans->charge = 0;
                $trans->user_available_balance = $user->balance;
                // $trans->receiver_available_balance = $receiver->balance;
                $trans->save();
            }
        }
        return redirect()->route('user.dashboard')->with('message', 'Bank Plan Updated');
    }
}
