<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\PaymentGateway;

class DepositController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data['deposits'] = Deposit::with('gateway')->orderby('id', 'desc')->whereUserId(auth()->id())->paginate(10);
        $data['pending'] = Deposit::whereStatus('pending')->whereUserId(auth()->id())->count();
        $data['complete'] = Deposit::whereStatus('complete')->whereUserId(auth()->id())->count();
        $data['cancelled'] = Deposit::whereStatus('cancelled')->whereUserId(auth()->id())->count();
        $data['processing'] = Deposit::whereStatus('processing')->whereUserId(auth()->id())->count();
        $data['onhold'] = Deposit::whereStatus('onhold')->whereUserId(auth()->id())->count();
        return view('user.deposit.index', $data);
    }

    public function create()
    {

        $data['availableGatways'] = ['flutterwave', 'authorize.net', 'razorpay', 'mollie', 'paytm', 'instamojo', 'stripe', 'paypal', 'paystack'];
        $data['gateways'] = PaymentGateway::orderBy('sorting_order')->whereStatus(1)->get();
        return view('user.deposit.create', $data);
    }
}
