<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\KycForm;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class KYCController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function kycform()
    {
        $userType = 'user';
        $userForms = KycForm::where('user_type', $userType == 'user' ? 1 : 2)->get();
        return view('user.kyc.index', compact('userType', 'userForms'));
    }

    public function kycformAgain()
    {
        $userType = 'user';
        $userForms = KycForm::where('user_type', $userType == 'user' ? 1 : 2)->get();
        $user = auth('web')->user();
        $kycInfo = json_decode($user->kyc_info, true);
        $kycReject = json_decode($user->kyc_reject, true);
        return view('user.kyc.indexAgain', compact('userType', 'userForms', 'kycInfo', 'kycReject', 'user'));
    }

    public function kyc(Request $request)
    {
        $userType = 'user';
        $userForms = KycForm::where('user_type', $userType == 'user' ? 1 : 2)->get();

        $rules = [];

        $requireInformations = [];
        if ($userForms) {
            foreach ($userForms as $key => $value) {
                if ($value->type == 1) {
                    $requireInformations['text'][$key] = strtolower(str_replace(' ', '_', $value->label));
                } else if ($value->type == 3) {
                    $requireInformations['textarea'][$key] = strtolower(str_replace(' ', '_', $value->label));
                } else {
                    $requireInformations['file'][$key] = strtolower(str_replace(' ', '_', $value->label));
                    $rules[$key] = 'mimes:jpeg,jpg,png,gif,pdf';
                }
            }
        }

        $this->validate($request, $rules);

        $details = [];
        foreach ($requireInformations as $key => $infos) {
            foreach ($infos as $index => $info) {

                if ($request->has($info)) {
                    if ($request->hasFile($info)) {
                        if ($file = $request->file($info)) {
                            $name = Str::random(8).time().'.'.$file->getClientOriginalExtension();
                            if (str_starts_with($file->getClientMimeType(), 'image/')) {
                                storeScaleDownImage($file, 'images', $name);
                            } else {
                                $file->move('assets/images', $name);
                            }
                            $details[$info] = [$name, $key];
                        }
                    } else {
                        $details[$info] = [$request->$info, $key];
                    }
                }
            }
        }

        $user = auth()->user();
        if (!empty($details)) {
            $user->kyc_info = json_encode($details, true);
        }
        $user->save();

        $msg = "$user->name $user->last_name KYC information submitted successfully";
        notifyAdmins($msg, 'kyc');

        return redirect()->route('user.dashboard')->with('message', 'KYC submitted successfully');
    }

    public function kycFace(Request $request)
    {
        $request->validate([
            'face_video' => 'required|mimetypes:video/x-matroska,video/webm',
        ]);

        $user = auth()->user();

        $video = $request->file('face_video');

        $fileName = md5($user->id).".webm";
        $video->storeAs("user/kyc/", $fileName, 'assets');

        $user->update(['kyc_face' => $fileName]);

        return [
            'status' => true,
            'message' => 'Video Uploaded Successfully',
        ];
    }

    public function kycAgain(Request $request)
    {
        $userType = 'user';
        $userForms = KycForm::where('user_type', $userType == 'user' ? 1 : 2)->get();

        $rules = [];

        $requireInformations = [];
        if ($userForms) {
            foreach ($userForms as $key => $value) {
                if ($value->type == 1) {
                    $requireInformations['text'][$key] = strtolower(str_replace(' ', '_', $value->label));
                } else if ($value->type == 3) {
                    $requireInformations['textarea'][$key] = strtolower(str_replace(' ', '_', $value->label));
                } else {
                    $rules[$key] = 'mimes:jpeg,jpg,png,gif,pdf';
                    $requireInformations['file'][$key] = strtolower(str_replace(' ', '_', $value->label));
                }
            }
        }

        $request->validate($rules);

        $user = auth('web')->user();

        $kycInfo = json_decode($user->kyc_info, true);
        foreach ($requireInformations as $key => $infos) {
            foreach ($infos as $index => $info) {

                if ($request->has($info)) {
                    if ($request->hasFile($info)) {
                        if ($file = $request->file($info)) {
                            $name = Str::random(8).time().'.'.$file->getClientOriginalExtension();
                            if (str_starts_with($file->getClientMimeType(), 'image/')) {
                                storeScaleDownImage($file, 'images', $name);
                            } else {
                                $file->move('assets/images', $name);
                            }
                            $kycInfo[$info] = [$name, $key];
                        }
                    } else {
                        $kycInfo[$info] = [$request->$info, $key];
                    }
                }
            }
        }

        $user = auth()->user();
        if (!empty($kycInfo)) {
            $user->kyc_info = json_encode($kycInfo, true);
            $user->kyc_status = 0;
        }
        $user->save();

        return redirect()->route('user.dashboard')->with('message', 'KYC submitted successfully');
    }
}
