<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Generalsetting;
use App\Models\User;
use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Tzsk\Otp\Facades\Otp;
use Validator;
use Illuminate\Support\Facades\DB;
use App\Mail\DeviceLoginMail;

class LoginController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest', ['except' => ['logout', 'userLogout']]);
    }

    public function showLoginForm()
    {
        return view('user.login');
    }

    public function login(Request $request)
    {
        $rules = [
            'email' => 'required|email',
            'password' => 'required'
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json(array('errors' => $validator->getMessageBag()->toArray()));
        }

        $user = User::where('email', $request->email)->first();

        if ($user) {
            if ($user->blocked_until && now()->lessThan($user->blocked_until)) {
                return response()->json(['errors' => [0 => 'Your account is blocked until ' . $user->blocked_until]]);
            }
        }

        $userIp = $request->ip();
        $gs = Generalsetting::first();
        $blockedIps = json_decode($gs->block_ips, true) ?? []; // decode blocked IPs

        // Check if IP is blocked
        if (in_array($userIp, $blockedIps)) {
            return response()->json(['errors' => [0 => 'Your IP is blocked from accessing this system!']]);
        }

        if (Auth::attempt(['email' => $request->email, 'password' => $request->password], $request->remember)) {

            $user->update([
                'login_attempts' => 0,
                'blocked_until' => null,
            ]);

            if($gs->is_location_active == 0){

           storeUserLog(request()->header('User-Agent'), request()->ip(),  $user->id);

            }
           
            

            session(['user_ip' => $request->ip()]);

            if (Auth::guard('web')->user()->is_banned == 1) {
                Auth::guard('web')->logout();
                return response()->json(array('errors' => [0 => 'You are Banned From this system!']));
            }

            if (Auth::guard('web')->user()->email_verified == 'No') {
                Auth::guard('web')->logout();
                return response()->json(array('errors' => [0 => 'Your Email is not Verified!']));
            }

            if (Auth::guard('web')->user()->email_2fa == 1) {
                $user = Auth::guard('web')->user();
                $otp = Otp::digits(6)->expiry(10)->generate($user->email);
                Mail::send([], [], function ($message) {
                    $emailBody = "Dear $user->name,\nYour OTP for the 2FA verification is $otp.\nDo not share this OTP with anyone.\nThank you";
                    $message->to($user->email);
                    $message->subject('2FA OTP Verification');
                    $message->html(nl2br($emailBody));
                    Log::info($emailBody);
                });

                $textMessage = "Your OTP is $otp";
                send_sms([$user->phone, $textMessage]);
            }

            if (session()->get('setredirectroute') != null) {
                return response()->json(session()->get('setredirectroute'));
            }
            $gs = Generalsetting::first();
            $user = auth()->user();

            $currentSessionId = session()->getId();

            if ($user->last_session_id && $user->last_session_id !== $currentSessionId) {
                // Destroy old session from DB
                DB::table('sessions')->where('id', $user->last_session_id)->delete();

                // Send notification email
                Mail::to($user->email)->send(new DeviceLoginMail($user, $request->ip()));
            }

            // Store new session id
            $user->last_session_id = $currentSessionId;
            $user->save();


            if ($gs->two_factor && $user->twofa) {
                return response()->json(route('user.otp'));
            } else {
                $user->update(['verified' => 1]);
               
                return response()->json(route('user.dashboard'));
            }
        }

        if ($user) {
            $user->increment('login_attempts');

            if ($user->login_attempts >= 3) {
                $user->update([
                    'blocked_until' => now()->addHours(2)
                ]);
                return response()->json(['errors' => [0 => 'Too many failed attempts. Your account is blocked for 2 hours.']]);
            }
        }

        return response()->json(array('errors' => [0 => 'Credentials Doesn\'t Match !']));
    }

    public function logout()
    {
        Auth::guard('web')->logout();
        session()->forget('setredirectroute');
        session()->forget('affilate');
        if (session('admin.impersonated_user_id')) {
            session()->forget('admin.impersonated_user_id');
            $userId = session('admin.logged_in_user_id');
            session()->forget('admin.logged_in_user_id');
            if ($userId) {
                Auth::guard('web')->loginUsingId($userId);
                if (request('to') == 'admin') {
                    return to_route('admin.dashboard');
                }
                return to_route('user.dashboard');
            }
            return to_route('admin.dashboard');
        }

        return redirect('/');
    }

    private function code_image()
    {
        $actual_path = str_replace('project', '', base_path());
        $image = imagecreatetruecolor(200, 50);
        $background_color = imagecolorallocate($image, 255, 255, 255);
        imagefilledrectangle($image, 0, 0, 200, 50, $background_color);

        $pixel = imagecolorallocate($image, 0, 0, 255);
        for ($i = 0; $i < 500; $i++) {
            imagesetpixel($image, rand() % 200, rand() % 50, $pixel);
        }

        $font = $actual_path . 'assets/front/fonts/NotoSans-Bold.ttf';
        $allowed_letters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        $length = strlen($allowed_letters);
        $letter = $allowed_letters[rand(0, $length - 1)];
        $word = '';

        $text_color = imagecolorallocate($image, 0, 0, 0);
        $cap_length = 6; // No. of character in image
        for ($i = 0; $i < $cap_length; $i++) {
            $letter = $allowed_letters[rand(0, $length - 1)];
            imagettftext($image, 25, 1, 35 + ($i * 25), 35, $text_color, $font, $letter);
            $word .= $letter;
        }
        $pixels = imagecolorallocate($image, 8, 186, 239);
        for ($i = 0; $i < 500; $i++) {
            imagesetpixel($image, rand() % 200, rand() % 50, $pixels);
        }
        session(['captcha_string' => $word]);
        imagepng($image, $actual_path . "assets/images/capcha_code.png");
    }
}
