<?php

namespace App\Http\Controllers\User;

use App\Classes\GeniusMailer;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\AdminUserConversation;
use App\Models\AdminUserMessage;
use App\Models\Generalsetting;
use App\Models\Notification;
use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class MessageController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function adminmessages()
    {
        $user = Auth::guard('web')->user();
        $convs = AdminUserConversation::where('user_id', '=', $user->id)->paginate();
        return view('user.message.index', compact('convs'));
    }

    public function messageload($id)
    {
        $conv = AdminUserConversation::findOrfail($id);
        return view('load.usermessage', compact('conv'));
    }

    public function adminmessage($id)
    {

        $conv = AdminUserConversation::findOrfail($id);
        $admin = Admin::where('id', 1)->first();
        return view('user.message.create', compact('conv', 'admin'));
    }


    public function adminmessagedelete($id)
    {
        $conv = AdminUserConversation::findOrfail($id);
        if ($conv->messages->count() > 0) {
            foreach ($conv->messages as $key) {
                $key->delete();
            }
        }
        $conv->delete();
        return redirect()->back()->with('success', 'Message Deleted Successfully');
    }

    public function adminpostmessage(Request $request)
    {
        $request->validate([
            'attachment' => 'mimes:jpeg,jpg,png,pdf,doc,docx',
        ]);


        $msg = new AdminUserMessage();
        $input = $request->all();

          if ($file = $request->file('attachment')) {
            $name = Str::random(8).time().'.'.$file->getClientOriginalExtension();
            $file->move('assets/files', $name);
            $input['attachment'] = $name;
        }

        $msg->fill($input)->save();

        $notification = new Notification;
        $notification->conversation_id = $msg->conversation->id;
        $notification->save();

        $conv = AdminUserConversation::find($request->conversation_id);
        $conv->is_read_admin = 1;
        $conv->update();

        //--- Redirect Section
        $msg = 'Message Sent!';

        notifyAdmins('New message from user', 'message');

        return response()->json($msg);
        //--- Redirect Section Ends
    }

    public function adminusercontact(Request $request)
    {
        $data = 1;
        $user = Auth::guard('web')->user();
        $gs = Generalsetting::findOrFail(1);
        $subject = $request->subject;
        $to = $gs->email;
        $from = $user->email;
        $msg = "Email: " . $from . "\nMessage: " . $request->message;
        if ($gs->is_smtp == 1) {
            $data = [
                'to' => $to,
                'subject' => $subject,
                'body' => $msg,
            ];

            $mailer = new GeniusMailer();
            $mailer->sendCustomMail($data);
        } else {
            $headers = "From: " . $gs->from_name . "<" . $gs->from_email . ">";
            mail($to, $subject, $msg, $headers);
        }

           if ($file = $request->file('attachment')) {
            $filename = Str::random(8).time().'.'.$file->getClientOriginalExtension();
            $file->move('assets/files', $filename);
        }


        $conv = AdminUserConversation::where('user_id', '=', $user->id)->where('subject', '=', $subject)->first();
        if (isset($conv)) {
            $msg = new AdminUserMessage();
            $msg->conversation_id = $conv->id;
            $msg->message = $request->message;
            $msg->user_id = $user->id;
            $msg->attachment = $filename ?? null;
            $msg->save();

            notifyAdmins('New message from user', 'message');

            return response()->json($data);
        } else {
            $message = new AdminUserConversation();
            $message->subject = $subject;
            $message->user_id = $user->id;
            $message->message = $request->message;
            $message->save();

            $notification = new Notification;
            $notification->conversation_id = $message->id;
            $notification->save();

            $msg = new AdminUserMessage();
            $msg->conversation_id = $message->id;
            $msg->message = $request->message;
            $msg->user_id = $user->id;
            $msg->attachment = $filename ?? null;
            $msg->save();

            notifyAdmins('New message from user', 'message');

            return response()->json($data);
        }
    }
}
