<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\PaymentMerchant;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class PaymentApiController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $merchant = PaymentMerchant::getKeys(auth()->id());

        if ($request->get('action') == 'enable-payment') {
            $merchant->update(['status' => !$merchant->status]);
            $status = $merchant->status == 1 ? 'Enabled' : 'Disabled';
            return [
                'status' => true,
                'enabled' => $merchant->status == 1,
                'message' => "Payment $status Successfully",
            ];
        }
        if ($request->get('action') == 'upload-logo') {
            return $this->uploadMerchantLogo($request, $merchant);
        }

        return view('user.payment.api', [
            'merchant' => $merchant,
            'user' => auth()->user(),
        ]);
    }

    public function test()
    {
        $merchant = PaymentMerchant::getKeys(auth()->id());

        return view('user.payment.test', [
            'merchant' => $merchant,
            'user' => auth()->user(),
        ]);
    }

    private function uploadMerchantLogo($request, $merchant)
    {
        $request->validate([
            'merchant_logo' => 'required|mimes:jpeg,jpg,png,gif',
        ]);
        $logo = $request->file('merchant_logo');
        $fileName = time().Str::random(4).'.'.$logo->getClientOriginalExtension();
        //$logo->storeAs('images/merchant', $fileName, 'assets');

        storeScaleDownImage($logo, 'images/merchant', $fileName, 120);

        if (!empty($merchant->merchant_logo)) {
            $oldLogo = 'images/merchant/'.$merchant->merchant_logo;
            if (Storage::disk('assets')->exists($oldLogo)) {
                Storage::disk('assets')->delete($oldLogo);
            }
        }

        $merchant->update(['merchant_logo' => $fileName]);

        return view('includes.user.fragments.upload_logo_form', [
            'merchant' => $merchant,
            'user' => auth()->user(),
        ]);
    }
}
