<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ReadAdminNotification
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->is('admin*') && $request->has('ref')) {
            if ($request->get('ref') == 'notification' && $request->has('id')) {
                auth('admin')->user()->notifications()->find($request->get('id'))?->markAsRead();

                return redirect($request->route()->uri);
            }
        }

        return $next($request);
    }
}
