<?php

namespace App\Jobs;

use App\Models\Deposit;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CancelPendingDepositsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // update pending deposits to "canceled" when create_at is more than 10 minutes
        Deposit::query()->where('status', 'pending')
            ->where('method', '!=', 'Manual')
            ->where('created_at', '<', now()->subMinutes(15))
            ->update(['status' => 'canceled']);
    }
}
