<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DeviceLoginMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $ip;

    public function __construct($user, $ip)
    {
        $this->user = $user;
        $this->ip = $ip;
    }

    public function build()
    {
        return $this->subject('New Device Login Detected')
                    ->view('emails.device_login')
                    ->with([
                        'name' => $this->user->name,
                        'ip'   => $this->ip,
                        'time' => now(),
                    ]);
    }
}
