<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankPlan extends Model
{
    use HasFactory;

    protected $guarded = ['*'];

    protected $fillable = [
        'send_money_charge',
        'bank_transfer_charge',
    ];

    protected $casts = [
        'send_money_charge' => 'object',
        'bank_transfer_charge' => 'object',
    ];

    public function getSendMoneyCharge(?User $user = null)
    {
        $user = $user ?? auth()->user();
        $charge = (object)['fixed' => 0, 'percent' => 0];
        return match ($user->account_type) {
            'agent' => $this->send_money_charge->agent ?? $charge,
            'merchant' => $this->send_money_charge->merchant ?? $charge,
            default => $this->send_money_charge->personal ?? $charge,
        };
    }


    public function getBankTransferCharge(?User $user = null)
    {
        $user = $user ?? auth()->user();
        $charge = (object)['fixed' => 0, 'percent' => 0];
        return match ($user->account_type) {
            'agent' => $this->bank_transfer_charge->agent ?? $charge,
            'merchant' => $this->bank_transfer_charge->merchant ?? $charge,
            default => $this->bank_transfer_charge->personal ?? $charge,
        };
    }
}
