<?php

namespace App\Models;

use Illuminate\{Database\Eloquent\Model, Database\Eloquent\Relations\BelongsTo};


class PaymentGateway extends Model
{
    protected $fillable = [
        'title',
        'details',
        'subtitle',
        'name',
        'type',
        'information',
        'additional_fields',
        'currency_id',
        'sorting_order',
        'logo',
        'withdraw_status',
        'withdraw_note',
        'withdraw_fee_fixed',
        'withdraw_fee_percentage',
        'fund_note',
        'fund_available',
        'sending_rate',
        'receiving_rate',
        'min_limit',
        'max_limit',
        'deposit_charge',
        'bank_plan_status',
        'deposit_charge_fix',
    ];
    public $timestamps = false;
    protected $casts = [
        'additional_fields' => 'array',
    ];

    protected $hidden = [
        'information'
    ];

    public function currency(): BelongsTo
    {
        return $this->belongsTo('App\Models\Currency')->withDefault();
    }

    public static function scopeHasGateway($curr)
    {
        return PaymentGateway::where('currency_id', 'like', "%\"{$curr}\"%")->get();
    }

    public function convertAutoData()
    {
        return json_decode($this->information, true);
    }

    public function getAutoDataText()
    {
        $data = $this->convertAutoData();
        return $data['text'] ?? '';
    }

    public function showKeyword()
    {
        $data = $this->keyword == null ? 'other' : $this->keyword;
        return $data;
    }

    public function getTitle()
    {
        return $this->title ?? $this->name;
    }
}
