<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class PaymentTransactions extends Model
{
    use HasUuids;

    protected $fillable = [
        'merchant_id',
        'amount',
        'currency',
        'reference',
        'status',
        'customer_data',
        'metadata',
        'description',
        'fee_amount',
        'payment_link_id',
        'payer_id',
        'processed_at',
    ];

    protected $casts = [
        'customer_data' => 'array',
        'metadata' => 'array',
    ];

    public static function generateReference(): string
    {
        return 'TXN_'.strtoupper(substr(md5(uniqid('', true)), 0, 12));
    }
}
