<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = [
        'email',
        'amount',
        'type',
        'profit',
        'txnid',
        'user_id',
        'charge',
        'receiver_id',
        'user_available_balance',
        'receiver_available_balance',
        'all_info',
        'bonus_point',
        'sender_id'
    ];


    public static function newEntry(array $array): Transaction
    {
        $trans = new Transaction;
        $trans->email = $array['email'];
        $trans->amount = $array['amount'];
        $trans->type = $array['type'];
        $trans->profit = $array['profit'];
        $trans->txnid = $array['txnid'];
        $trans->user_id = $array['user_id'];
        $trans->save();

        return $trans;
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User')->withDefault();
    }


    public function receiver_user()
    {
        return $this->belongsTo('App\Models\User', 'receiver_id')->withDefault();
    }

    public function sender_user()
    {
        return $this->belongsTo('App\Models\User', 'sender_id')->withDefault();
    }
}
