<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use Notifiable;

    protected $fillable = [
        'bank_plan_id', 'account_number', 'name', 'last_name', 'photo', 'zip', 'residency', 'city', 'address', 'phone', 'fax', 'email', 'password', 'verification_link', 'affilate_code', 'is_provider', 'twofa', 'go', 'details', 'kyc_status', 'kyc_info', 'kyc_reject', 'plan_end_date', 'currency_id',
        'phone_verified_at', 'email_verified_at', 'kyc_face', 'account_type', 'bonus_point','blocked_until', 'login_attempts', 'last_session_id', 'dob', 'telegram', 'country'
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    protected $dates = [
        'plan_end_date',
    ];

    /*public function getPhoneAttribute()
    {
        return preg_replace("/[^0-9+]/", "", $this->getAttribute('phone'));
    }*/

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }

    public function subscriptions()
    {
        return $this->hasMany(UserSubscription::class);
    }

    public function balanceTransfers()
    {
        return $this->hasMany(BalanceTransfer::class);
    }

    public function bankPlan(): BelongsTo
    {
        return $this->belongsTo(BankPlan::class, 'bank_plan_id');
    }

    public function fdr()
    {
        return $this->hasMany(UserFdr::class);
    }

    public function dps()
    {
        return $this->hasMany(UserDps::class);
    }

    public function loans()
    {
        return $this->hasMany(UserLoan::class);
    }

    public function wiretransfers()
    {
        return $this->hasMany(WireTransfer::class);
    }

    public function deposits()
    {
        return $this->hasMany(Deposit::class);
    }

    public function withdraws()
    {
        return $this->hasMany(Withdraw::class);
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function socialProviders()
    {
        return $this->hasMany('App\Models\SocialProvider');
    }

    public function notifications()
    {
        return $this->hasMany('App\Models\Notification');
    }

    public function transactions()
    {
        return $this->hasMany('App\Models\Transaction', 'user_id');
    }

    public function adminTransactions()
    {
        return $this->hasMany(AdminTransaction::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_code', 'id');
    }
}
