<?php

namespace App\Models;

use App\Models\StatusChangeHistory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserDps extends Model
{
    use HasFactory;

    protected $fillable = [
        'transaction_no',
        'user_id',
        'dps_plan_id',
        'per_installment',
        'installment_interval',
        'total_installment',
        'given_installment',
        'deposit_amount',
        'matured_amount',
        'interest_rate',
        'status',
        'is_given',
    ];

    protected $dates = [
        'next_installment',
    ];

    public function plan()
    {
        return $this->belongsTo(DpsPlan::class, 'dps_plan_id')->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function lastHistory()
    {
        return $this->hasOne(StatusChangeHistory::class, 'model_id')
            ->where('type', 'dps')
            ->with('admin:id,name')
            ->latest('created_at');
    }

    public function histories()
    {
        return $this->hasMany(StatusChangeHistory::class, 'model_id')->where('type', 'dps')->with('admin:id,name')->orderBy('created_at', 'desc');
    }
}
