<?php

namespace App\Models;

use App\Models\StatusChangeHistory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Withdraw extends Model
{
    // protected $fillable = ['txnid','user_id', 'method', 'acc_email', 'iban', 'country', 'acc_name', 'address', 'swift', 'reference', 'amount', 'fee','details', 'created_at', 'updated_at', 'status', 'status_updated_at'];
    protected $guarded = ['id'];

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function gateway(): BelongsTo
    {
        return $this->belongsTo(PaymentGateway::class, 'gateway_id');
    }

    protected static function booted(): void
    {

        static::created(function ($withdraw) {
            $currency = Currency::whereIsDefault(true)->first();
            $amount = number_format(round($withdraw->amount, 2), 2);
            notifyAdmins("{$withdraw->user->name} requested withdraw {$amount} {$currency->name} via {$withdraw->method}", 'withdraw');
        });
    }

    public function lastHistory()
        {
            return $this->hasOne(StatusChangeHistory::class, 'model_id')
                ->where('type', 'withdraw')
                ->with('admin:id,name')
                ->latest('created_at');
        }


    public function histories()
    {
        return $this->hasMany(StatusChangeHistory::class, 'model_id')->where('type', 'withdraw')->with('admin:id,name')->orderBy('created_at', 'desc');
    }
}
