<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tawk_scripts', function (Blueprint $table) {
            $table->id();
            $table->text('whatsapp_tawk_script')->nullable();
            $table->boolean('whatsapp_tawk_enabled')->default(false);
            $table->text('messenger_tawk_script')->nullable();
            $table->boolean('messenger_tawk_enabled')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tawk_scripts');
    }
};
