<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            $table->string('status', 100)->default('pending')->change(); // ALTER TABLE `deposits` CHANGE `status` `status` VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending';
            $table->json('additional_data')->nullable()->after('status');
            $table->unsignedBigInteger('gateway_id')->nullable()->after('method'); // ALTER TABLE `deposits` ADD `gateway_id` BIGINT UNSIGNED NULL AFTER `method`;
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            $table->dropColumn('additional_data');
        });
    }
};
