<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('dial_code')->after('phone')->nullable();
            $table->string('country_code')->after('dial_code')->nullable();
            // alter table `users` add `dial_code` varchar(255) null after `phone`
            // alter table `users` add `country_code` varchar(255) null after `dial_code`
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('dial_code');
            $table->dropColumn('country_code');
        });
    }
};
