<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
              $table->timestamp('status_updated_at')->nullable();
              $table->tinyInteger('is_fund_add')->default(0);
              $table->tinyInteger('is_amount_add')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
                $table->dropColumn(['status_updated_at', 'is_fund_add', 'is_amount_add']);
        });
    }
};
