<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('seotools', function (Blueprint $table) {
            $table->text('meta_description')->nullable();
            $table->string('social_title')->nullable();
            $table->text('social_description')->nullable();
            $table->string('logo')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('seotools', function (Blueprint $table) {
            $table->dropColumn(['meta_description', 'social_title', 'social_description', 'logo']);
        });
    }
};
