<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('status_change_histories', function (Blueprint $table) {
            $table->id();
            $table->integer('model_id')->nullable();
            $table->unsignedBigInteger('admin_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('type')->nullable()->comment('deposit, withdraw, other_bank, wire_transfer, loan, fdr, dps, bank_plan');
            $table->string('privious_status')->nullable();
            $table->string('current_status')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('status_change_histories');
    }
};
