@php
    use App\Models\UserDps;
    use App\Models\UserFdr;
    use App\Models\UserLoan;
@endphp
@extends('layouts.admin')

@section('content')

    <div class="d-sm-flex align-items-center justify-content-between mb-4 py-3">
        <h1 class="h3 mb-0 text-gray-800">{{ __('Dashboard') }}</h1>
        <ol class="breadcrumb m-0 py-0">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
        </ol>
    </div>
    @if (Session::has('cache'))
        <div class="alert alert-success validation">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span
                    aria-hidden="true">×</span></button>
            <h3 class="text-center">{{ Session::get('cache') }}</h3>
        </div>
    @endif

    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Active Customers') }}</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ count($acustomers) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Blocked Customers') }}</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ count($bcustomers) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Blogs') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ count($blogs) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-fw fa-newspaper fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Deposits') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ count($deposits) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Loan') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ count(UserLoan::get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Pending Loan') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ count(UserLoan::whereStatus(0)->get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Running Loan') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ count(UserLoan::whereStatus(1)->get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Paid Loan') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ count(UserLoan::whereStatus(3)->get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Rejected Loan') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ count(UserLoan::whereStatus(2)->get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total DPS') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ count(UserDps::get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Running DPS') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ count(UserDps::whereStatus(1)->get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Matured DPS') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ count(UserDps::whereStatus(2)->get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total FDR') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ count(UserFdr::get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Running FDR') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ count(UserFdr::whereStatus(1)->get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Closed FDR') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ count(UserFdr::whereStatus(2)->get()) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Bonus Point') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ $totalBonusPoint }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-coins fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Transactions') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ count($transactions) }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Customer Balance') }}
                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ amount_format($usersTotalBalance) }} {{ $currency->name }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- new added --}}
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Customer Loan') }}
                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ amount_format($loanamount) }} {{ $currency->name }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Customer Dps') }}
                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ amount_format($dpsamount) }} {{ $currency->name }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Customer Fdr') }}
                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ amount_format($fdramount) }} {{ $currency->name }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- new added end --}}

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Deposit Amount') }}
                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ amount_format($depositAmount) }}
                                {{ $currency->name }} </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Withdraw Amount') }}
                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ amount_format($withdrawAmount) }}
                                {{ $currency->name }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

            <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">{{ __('Total Withdraw Pending Amount') }}
                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">{{ amount_format($withdrawPendingAmount) }}
                                {{ $currency->name }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">
                                {{ __('Total Withdraw Charge Amount') }}</div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                {{ amount_format($withdrawChargeAmount) }} {{ $currency->name }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-xl-12 col-lg-12 mb-4">
            <div class="card">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">@lang('Profit & Loss')</h6>
                </div>
                <canvas id="profitLossChart" style="min-height: 350px; height: 350px;"></canvas>
            </div>
        </div>
    </div>


    <div class="row mb-3">
        <div class="col-xl-12 col-lg-12 mb-4">
            <div class="card">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">@lang('Recent Joined Users')</h6>
                </div>
                @if (count($users) > 0)
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                    <th>@lang('Serial No')</th>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Email')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $key => $data)
                                    <tr>
                                        <td data-label="@lang('Serial No')">{{ $loop->iteration }}</td>
                                        <td data-label="@lang('Name')">{{ $data->name }}</td>
                                        <td data-label="@lang('Email')">{{ $data->email }}</td>
                                        <td data-label="@lang('Status')"><span
                                                class="badge badge-{{ $data->is_banned == 0 ? 'success' : 'danger' }}">{{ $data->is_banned == 0 ? 'activated' : 'deactivated' }}</span>
                                        </td>
                                        <td data-label="@lang('Action')"><a
                                                href="{{ route('admin-user-show', $data->id) }}"
                                                class="btn btn-sm btn-primary">@lang('Detail')</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer"></div>
                @else
                    <p class="text-center">@lang('NO USER FOUND')</p>
                @endif
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const rawData = @json($monthlyProfitLoss ?? []);

        if (!Array.isArray(rawData)) {
            console.error("Profit/loss data is not an array:", rawData);
            return;
        }

        const labels = rawData.map(item => item.month);
        const netValues = rawData.map(item => item.net);

        const ctx = document.getElementById('profitLossChart').getContext('2d');
        const currencySign = @json(globalCurrency()->sign);

        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Profit / Loss',
                    data: netValues,
                    backgroundColor: netValues.map(v => v >= 0 ? 'rgba(40, 167, 69, 0.8)' : 'rgba(220, 53, 69, 0.8)'),
                    borderColor: netValues.map(v => v >= 0 ? 'rgba(40, 167, 69, 1)' : 'rgba(220, 53, 69, 1)'),
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    title: {
                        display: true,
                        text: 'Monthly Profit / Loss (Last 12 Months)'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const val = context.raw;
                                const type = val >= 0 ? 'Profit' : 'Loss';
                                return `${type}: ${currencySign}${Math.abs(val)}`;
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return currencySign + value;
                            }
                        }
                    }
                }
            }
        });
    });
</script>
@endsection