<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Statement - {{ $date }}</title>
    <style>
        * {
            font-family: sans-serif;
            font-size: 12px;
            padding: 0;
            margin: 0;
            outline: 0;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        table, th, td {
            border: 1px solid #4f4f4f;
            padding: 4px 5px;
            line-height: 1 !important;
        }

        .text-center {
            text-align: center;
        }

        .text-end {
            text-align: right;
        }

        .text-title {
            font-size: 1.5rem;
            padding-top: 5px
        }

        .text-subtitle {
            font-size: 1.25rem;
            padding-top: 5px
        }

        .w-1 {
            width: 1%;
        }
    </style>
</head>
<body>
<div style="padding: 30px;">
    <div style="padding-bottom: 20px">
        <h2 class="text-center text-title">{{ $title }}</h2>
        <h4 class="text-center text-subtitle">Statement - {{ $date }}</h4>
        {{-- <p class="text-center" style="font-size: 1.25rem; padding-top: 5px">Period: {{ request('from') }}
            to {{ request('to') }}</p> --}}
    </div>
    <table>
        <thead>
        <tr>
            <th class="w-1 text-center">@lang('S/N')</th>
            <th>@lang('Date')</th>
            <th>@lang('Deposit')</th>
            <th>@lang('Customer name')</th>
            <th>@lang('Customer Email')</th>
            <th>@lang('Status')</th>
            <th>@lang('Last Status')</th>
            <th>@lang('Amount')</th>
        </tr>
        </thead>
        <tbody>
         @forelse ($deposits as $key=>$data)
            <tr>
                <td class="w-1 text-center" data-label="@lang('No')">
                    <div>
                        <span class="text-muted">{{ $loop->iteration }}</span>
                    </div>
                </td>

                <td data-label="@lang('Date')">
                    <div>
                        {{date('d M Y',strtotime($data->created_at))}}
                    </div>
                </td>

                <td data-label="@lang('Deposit')">
                    <div>
                        {{ $data->deposit_number }}
                    </div>
                </td>

                <td data-label="@lang('Customer name')">
                    <div>
                        {{ $data->user->name ?? '-' }}
                    </div>
                </td>


                <td data-label="@lang('Customer Email')">
                    {{ $data->user->email ?? '-' }}
                </td>

                <td data-label="@lang('Status')">
                    {{ $data->status }}
                </td>

                <td data-label="@lang('Last Status')">
                    @php
                        if ($data->lastHistory) {
                            $name = e($data->lastHistory->admin->name);
                            $time = $data->lastHistory->created_at;
                        }
                    @endphp
                    {{ $name }}
                    <br>
                    <small>{{$time}}</small>
                </td>

                 <td data-label="@lang('Amount')" class="text-end">
                    {{ $data->amount }}
                </td>
            </tr>
        @empty
            <p>@lang('NO DATA FOUND')</p>
        @endforelse
        </tbody> 
    </table>
</div>
</body>
</html>
