<table>
    <thead>
    <tr>
        <th colspan="7" style="text-align: center">{{ $title }}</th>
    </tr>
    <tr>
        <th colspan="7" style="text-align: center">Statement - {{ $date }}</th>
    </tr>
    <tr>
        <th colspan="7" style="text-align: center">Period: {{ request('from') }}
            to {{ request('to') }}</th>
    </tr>
    <tr>
        <th class="w-1 text-center">@lang('S/N')</th>
            <th>@lang('Date')</th>
            <th>@lang('Deposit')</th>
            <th>@lang('Customer name')</th>
            <th>@lang('Customer Email')</th>
            <th>@lang('Status')</th>
            <th>@lang('Last Status')</th>
            <th>@lang('Amount')</th>
    </tr>
    </thead>
    <tbody>
     @foreach ($deposits as $key=>$data)
      <tr>
                <td class="w-1 text-center" data-label="@lang('No')">
                    <div>
                        <span class="text-muted">{{ $loop->iteration }}</span>
                    </div>
                </td>

                <td data-label="@lang('Date')">
                    <div>
                        {{date('d M Y',strtotime($data->created_at))}}
                    </div>
                </td>

                <td data-label="@lang('Deposit')">
                    <div>
                        {{ $data->deposit_number }}
                    </div>
                </td>

                <td data-label="@lang('Customer name')">
                    <div>
                        {{ $data->user->name ?? '-' }}
                    </div>
                </td>


                <td data-label="@lang('Customer Email')">
                    {{ $data->user->email ?? '-' }}
                </td>

                <td data-label="@lang('Status')">
                    {{ $data->status }}
                </td>

                <td data-label="@lang('Last Status')">
                    @php
                        if ($data->lastHistory) {
                            $name = e($data->lastHistory->admin->name);
                            $time = $data->lastHistory->created_at;
                        }
                    @endphp
                    {{ $name }}
                    <br>
                    <small>{{$time}}</small>
                </td>

                 <td data-label="@lang('Amount')" class="text-end">
                    {{ $data->amount }}
                </td>
            </tr>
    @endforeach 
    </tbody>
</table>
