@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('DPS') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.dps.index') }}">{{ __('DPS') }}</a></li>
            </ol>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-lg-12">

            @include('includes.admin.form-success')

            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                        <tr>
                            <th>{{__('Plan No')}}</th>
                            <th>{{__('Deposit Amount')}}</th>
                            <th>{{__('User')}}</th>
                            <th>{{__('Total Installment')}}</th>
                            <th>{{__('Matured Amount')}}</th>
                            <th>{{__('Next Installment')}}</th>
                            <th>{{__('Status')}}</th>
                            <th> {{ __('Last Status') }} </th>
                            <th>{{__('Action')}}</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    {{-- STATUS MODAL --}}

    <div class="modal fade confirm-modal" id="dpsCloseModal" tabindex="-1" role="dialog"
         aria-labelledby="dpsCloseModalTitle" aria-hidden="true">void(0)
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __("Close DPS") }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __("You are about to close the DPS.") }}</p>
                    <p class="text-center">{{ __("Do you want to proceed?") }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:void(0);" class="btn btn-secondary" data-dismiss="modal">{{ __("Cancel") }}</a>
                    <a href="javascript:void(0);" class="btn btn-success btn-ok">{{ __("Close") }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- STATUS MODAL ENDS --}}


    {{-- ADD AMOUNT MODAL --}}

    <div class="modal fade confirm-modal" id="dpsAddAmountModal" tabindex="-1" role="dialog"
        aria-labelledby="dpsAddAmountModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __("Add Amount to Pending DPS") }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __("This DPS has a pending installment due to insufficient balance.") }}</p>
                    <p class="text-center">{{ __("Do you want to deposit the required amount to continue the DPS?") }}</p>
                    <p class="text-center font-weight-bold">
                        {{ __("Amount to deposit:") }} <span id="pendingAmount"></span>
                    </p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:void(0);" class="btn btn-secondary" data-dismiss="modal">{{ __("Cancel") }}</a>
                    <a href="javascript:void(0);" class="btn btn-success btn-ok">{{ __("Add Amount") }}</a>
                </div>
            </div>
        </div>
    </div>


    {{-- ADD AMOUNT MODAL ENDS --}}

@endsection


@section('scripts')

    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '{{ route('admin.dps.datatables',['status' => 'all']) }}',
            columns: [
                {data: 'transaction_no', name: 'transaction_no'},
                {data: 'deposit_amount', name: 'deposit_amount'},
                {data: 'user_id', name: 'user_id'},
                {data: 'total_installment', name: 'total_installment'},
                {data: 'matured_amount', name: 'matured_amount'},
                {data: 'next_installment', name: 'next_installment'},
                {data: 'status', searchable: false},
                {data: 'status_last_history', name: 'lastHistory.admin.name'},
                {data: 'action', searchable: false, orderable: false}
            ],
            language: {
                processing: '<img src="{{asset('assets/images/'.$gs->admin_loader)}}">'
            }
        });


        // When modal opens
        $('#dpsAddAmountModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var url = button.data('href');
            var amount = button.data('amount');

            var modal = $(this);

            modal.find('.btn-ok').attr('href', url);
            modal.find('#pendingAmount').text(amount);
        });
    </script>
@endsection