@extends('layouts.admin')
@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('FDR') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.fdr.index') }}">{{ __('FDR') }}</a></li>
            </ol>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-lg-12">

            @include('includes.admin.form-success')

            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                        <tr>
                            <th>{{__('Plan No')}}</th>
                            <th>{{__('User')}}</th>
                            <th>{{__('Fdr Amount')}}</th>
                            <th>{{__('Profit Type')}}</th>
                            <th>{{__('Profit')}}</th>
                            <th>{{__('Status')}}</th>
                            <th> {{ __('Last Status') }} </th>
                            <th>{{__('Action')}}</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    {{-- STATUS MODAL --}}
    <div class="modal fade confirm-modal" id="fdrCloseModal" tabindex="-1" role="dialog"
         aria-labelledby="fdrCloseModalTitle" aria-hidden="true">void(0)
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __("Close FDR") }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __("You are about to close the FDR.") }}</p>
                    <p class="text-center">{{ __("Do you want to proceed?") }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:void(0);" class="btn btn-secondary" data-dismiss="modal">{{ __("Cancel") }}</a>
                    <a href="javascript:void(0);" class="btn btn-success btn-ok">{{ __("Close") }}</a>
                </div>
            </div>
        </div>
    </div>
    {{-- STATUS MODAL ENDS --}}
@endsection
@section('scripts')
    <script type="text/javascript">
        "use strict";
        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '{{ route('admin.fdr.datatables',['status' => 'all']) }}',
            columns: [
                {data: 'transaction_no', name: 'transaction_no'},
                {data: 'user_id', name: 'user_id'},
                {data: 'amount', name: 'amount'},
                {data: 'profit_type', name: 'profit_type'},
                {data: 'profit_amount', name: 'profit_amount'},
                {data: 'status', name: 'status'},
                {data: 'status_last_history', name: 'lastHistory.admin.name'},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ],
            language: {
                processing: '<img src="{{asset('assets/images/'.$gs->admin_loader)}}">'
            }
        });
    </script>
@endsection