@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Bulk Sms Bd') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Bulk Sms Bd Settings') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="card mb-4 mt-3">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Bulksmsbd Form') }}</h6>
        </div>

        <div class="card-body">
            <div class="gocover"
                style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
            </div>
            <form class="geniusform" action="{{ route('admin.gs.update') }}" method="POST" enctype="multipart/form-data">

                @include('includes.admin.form-both')

                {{ csrf_field() }}

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="inp-key">{{ __('bulksmsbd Api key') }}</label>
                            <input type="text" class="form-control" id="inp-key" name="bulksmsbd_api_key"
                                placeholder="{{ __('bulksmsbd Api key') }}" value="{{ $gs->bulksmsbd_api_key }}">
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="bulksmsbd_sender_id">{{ __('Bulksmsbd Sender Id') }}</label>
                            <input type="text" class="form-control" id="bulksmsbd_sender_id" name="bulksmsbd_sender_id"
                                placeholder="{{ __('Bulksmsbd Sender Id') }}" value="{{ $gs->bulksmsbd_sender_id }}">
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="bulksmsbd_api_endpoint">{{ __('Bulksmsbd Api Endpoint') }}</label>
                            <input type="text" class="form-control" id="bulksmsbd_api_endpoint" name="bulksmsbd_api_endpoint"
                                placeholder="{{ __('Bulksmsbd Api Endpoint') }}" value="{{ $gs->bulksmsbd_api_endpoint }}">
                        </div>
                    </div>


                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="inp-name">{{ __('Status') }}</label>
                            <select class="form-control mb-3" name="bulksmsbd_status">
                                <option value="1" {{ $gs->bulksmsbd_status == 1 ? 'selected' : '' }}>
                                    {{ __('YES') }}</option>
                                <option value="0" {{ $gs->bulksmsbd_status == 0 ? 'selected' : '' }}>
                                    {{ __('NO') }}</option>
                            </select>
                        </div>
                    </div>

                </div>

                <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>

            </form>
        </div>
    </div>
@endsection
