@extends('layouts.admin')

@section('content')

    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex align-items-center gap-3">
                    <h5 class="mb-0">{{ $title }}</h5>
                </div>
                <div class="card-body" data-simplebar>

                    <form id="maintenance_mode_form" action="{{ url()->current() }}" method="POST">
                        @csrf

                        <div class="mt-4">
                            <div class="d-flex align-items-center justify-content-center flex-column">
                                <div class="my-2 d-flex align-items-center">
                                    <input type="checkbox" data-toggle="toggle" data-size="lg"
                                           id="down_switch" name="maintenance_mode" @checked($down)/>
                                </div>

                                <div class="mt-2">
                                    <label for="maintenance_mode">Maintenance Mode</label>
                                    <span>{{ $down ?  __('Enabled') : __('Disabled') }}</span>
                                </div>
                            </div>

                            <div class="mt-3 text-center">
                                @if($down)
                                    <span class="text-warning"><strong>{{ __('The site is now in maintenance mode. Only admins can access the site.') }}</strong></span>
                                @else
                                    <span class="text-success">{{ __('The site is now in live mode.') }}</span>
                                @endif
                            </div>
                        </div>
                    </form>

                    <div class="mt-4">
                        <form action="{{ route('maintenance-mode.page-update') }}" method="POST"
                              enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="details">{{ __('Maintenance Page Design') }}</label>
                                <textarea class="form-control summernote" id="page" name="page" rows="4"
                                          placeholder="{{ __('Maintenance Page Design') }}">{{ $page }}</textarea>
                            </div>
                            <button class="btn btn-primary mt-3" type="submit">Save</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('styles')
    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css"
          rel="stylesheet">
@endsection
@section('scripts')
    <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>
    <script>
        $(function () {
            $(document).on('change', '#down_switch', function (event) {
                event.preventDefault();
                $('#maintenance_mode_form').submit();
            });
        });
    </script>
@endsection
