@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Notice') }}</h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('General Settings') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.gs.notice') }}">{{ __('Notice') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card mb-4 mt-3">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('For Deposit Notice') }}</h6>
                </div>

                <div class="card-body">
                    <form class="geniusform" action="{{ route('admin.gs.update') }}" method="POST"
                          enctype="multipart/form-data">
                        @include('includes.admin.form-both')
                        {{ csrf_field() }}
                        <div class="form-group">
                            <input type="text" class="form-control" id="deposit_notice" name="deposit_notice"
                                   placeholder="{{ __('For Deposit Notice') }}" value="{{ $gs->deposit_notice }}"
                                   required>
                        </div>
                        <button type="submit" id="submit-btn"
                                class="btn btn-primary btn-block">{{ __('Submit') }}</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card mb-4 mt-3">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('For Withdraw Notice') }}</h6>
                </div>

                <div class="card-body">
                    <form class="geniusform" action="{{ route('admin.gs.update') }}" method="POST"
                          enctype="multipart/form-data">
                        @include('includes.admin.form-both')
                        {{ csrf_field() }}
                        <div class="form-group">
                            <input type="text" class="form-control" id="withdraw_notice" name="withdraw_notice"
                                   placeholder="{{ __('For Withdraw Notice') }}" value="{{ $gs->withdraw_notice }}"
                                   required>
                        </div>
                        <button type="submit" id="submit-btn"
                                class="btn btn-primary btn-block">{{ __('Submit') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection

