@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center py-3 justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Missed Installments') }} <a class="btn btn-primary btn-rounded btn-sm"
                                                                             href="{{route('admin.loan.index')}}"><i
                        class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.loan.index') }}">{{ __('Loans') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Missed Installments') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-lg-12">
            @include('includes.admin.form-success')
            
            <div class="row">
                <div class="col-lg-6">
                    <div class="special-box">
                        <div class="heading-area">
                            <h4 class="title">
                                {{__('Loan Information')}}
                            </h4>
                        </div>
                        <div class="table-responsive-sm">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <th width="45%">{{__('Transaction No')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">{{$loan->transaction_no}}</td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('Plan Name')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">{{$loan->plan->title}}</td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('User')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">
                                        {{$loan->user->name}} {{$loan->user->last_name}}
                                        @if($loan->user->is_suspended)
                                            <span class="badge badge-danger">Suspended</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('User Email')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">{{$loan->user->email}}</td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('User Balance')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">{{ $currency->sign}} {{number_format($loan->user->balance, 2)}}</td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('Loan Amount')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">{{ $currency->sign}} {{number_format($loan->loan_amount, 2)}}</td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('Total Installments')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">{{$loan->total_installment}}</td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('Given Installments')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">{{$loan->given_installment}}</td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('Missed Installments')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%"><span class="badge badge-danger">{{$loan->missed_installment_count}}</span></td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('Remaining Installments')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">{{$loan->total_installment - $loan->given_installment}}</td>
                                </tr>
                                @if($loan->user->is_suspended)
                                <tr>
                                    <th width="45%">{{__('Suspend Reason')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%"><span class="text-danger">{{$loan->user->suspend_reason}}</span></td>
                                </tr>
                                @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="special-box">
                        <div class="heading-area">
                            <h4 class="title">
                                {{__('Unpaid Missed Installments Summary')}}
                            </h4>
                        </div>
                        <div class="table-responsive-sm">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <th width="45%">{{__('Total Unpaid Missed')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%"><span class="badge badge-danger">{{$unpaidMissed->count()}}</span></td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('Total Amount Due')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%"><strong class="text-danger">{{ $currency->sign}} {{number_format($totalUnpaidAmount, 2)}}</strong></td>
                                </tr>
                                <tr>
                                    <th width="45%">{{__('User Available Balance')}}</th>
                                    <th width="10%">:</th>
                                    <td width="45%">
                                        {{ $currency->sign}} {{number_format($loan->user->balance, 2)}}
                                        @if($loan->user->balance >= $totalUnpaidAmount)
                                            <span class="badge badge-success">Sufficient</span>
                                        @else
                                            <span class="badge badge-danger">Insufficient</span>
                                        @endif
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        @if($unpaidMissed->count() > 0)
                        <div class="footer-area mt-3">
                            @if($loan->user->balance >= $totalUnpaidAmount)
                                <button type="button" class="btn btn-success" onclick="payMissedInstallments()">
                                    <i class="fas fa-check-circle"></i> {{__('Process Payment & Unsuspend User')}}
                                </button>
                            @else
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle"></i> 
                                    {{__('User does not have sufficient balance to pay missed installments.')}}
                                    <br>
                                    {{__('Required')}} : {{ $currency->sign}} {{number_format($totalUnpaidAmount, 2)}}
                                    <br>
                                    {{__('Available')}} : {{ $currency->sign}} {{number_format($loan->user->balance, 2)}}
                                    <br>
                                    {{__('Shortage')}} : {{ $currency->sign}} {{number_format($totalUnpaidAmount - $loan->user->balance, 2)}}
                                </div>
                            @endif

                            @if($loan->user->is_suspended)
                            <div class="mt-3">
                                <h6>{{__('Custom Amount Payment & Unblock')}}</h6>
                                <div class="form-group">
                                    <label for="custom_amount">{{__('Amount to Deduct')}} ({{ $currency->sign}})</label>
                                    <input type="number" 
                                           class="form-control" 
                                           id="custom_amount" 
                                           placeholder="Enter amount" 
                                           step="0.01" 
                                           min="0"
                                           max="{{ $loan->user->balance }}"
                                           value="{{ min($totalUnpaidAmount, $loan->user->balance) }}">
                                    <small class="form-text text-muted">
                                        {{__('Maximum available')}}: {{ $currency->sign}} {{number_format($loan->user->balance, 2)}}
                                    </small>
                                </div>
                                <button type="button" class="btn btn-primary" onclick="unblockWithCustomAmount()">
                                    <i class="fas fa-unlock-alt"></i> {{__('Deduct Amount & Unblock User')}}
                                </button>
                                <button type="button" class="btn btn-warning ml-2" onclick="unsuspendUser()">
                                    <i class="fas fa-unlock"></i> {{__('Unblock Without Payment')}}
                                </button>
                            </div>
                            @endif
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            @if($loan->missedInstallments->count() > 0)
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="special-box">
                        <div class="heading-area">
                            <h4 class="title">
                                {{__('Missed Installments Details')}}
                            </h4>
                        </div>
                        <div class="table-responsive show-table">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>{{__('SL')}}</th>
                                        <th>{{__('Installment No')}}</th>
                                        <th>{{__('Amount')}}</th>
                                        <th>{{__('Due Date')}}</th>
                                        <th>{{__('Missed Date')}}</th>
                                        <th>{{__('Days Overdue')}}</th>
                                        <th>{{__('Status')}}</th>
                                        <th>{{__('Paid Date')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($loan->missedInstallments as $key => $missed)
                                        <tr class="{{ $missed->is_paid ? '' : 'table-danger' }}">
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $missed->installment_number }}</td>
                                            <td>{{ $currency->sign}} {{ number_format($missed->amount, 2) }}</td>
                                            <td>{{ $missed->due_date->format('Y-m-d') }}</td>
                                            <td>{{ $missed->missed_date->format('Y-m-d H:i') }}</td>
                                            <td>
                                                @if($missed->is_paid)
                                                    {{ $missed->due_date->diffInDays($missed->paid_date) }} days
                                                @else
                                                    {{ $missed->due_date->diffInDays(now()) }} days
                                                @endif
                                            </td>
                                            <td>
                                                @if($missed->is_paid)
                                                    <span class="badge badge-success">Paid</span>
                                                @else
                                                    <span class="badge badge-danger">Unpaid</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($missed->is_paid)
                                                    {{ $missed->paid_date->format('Y-m-d H:i') }}
                                                @else
                                                    --
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="2">{{__('Total Unpaid')}}</th>
                                        <th colspan="6">{{ $currency->sign}} {{ number_format($totalUnpaidAmount, 2) }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            @endif

        </div>
    </div>

@endsection

@section('scripts')
<script>
    function payMissedInstallments() {
        if (!confirm('Are you sure you want to process payment for all missed installments? This will deduct {{ $currency->sign}}{{ number_format($totalUnpaidAmount, 2) }} from user balance and unsuspend the user.')) {
            return;
        }

        $.ajax({
            url: '{{ route("admin.loan.pay.missed.installments", $loan->id) }}',
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                toastr.error('An error occurred while processing payment.');
            }
        });
    }

    function unsuspendUser() {
        if (!confirm('Are you sure you want to unsuspend this user without payment? The missed installments will remain unpaid.')) {
            return;
        }

        $.ajax({
            url: '{{ route("admin.loan.unsuspend.user", $loan->id) }}',
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                toastr.error('An error occurred while unsuspending user.');
            }
        });
    }
</script>
@endsection
