@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Strategy Section') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Home Page Setting') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="card mb-4 mt-3">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Strategy Section') }}</h6>
        </div>

        <div class="card-body">
            <div class="gocover"
                 style="background: url({{asset('assets/images/'.$gs->admin_loader)}}) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
            <form class="geniusform" action="{{route('admin.ps.update')}}" method="POST" enctype="multipart/form-data">

                @include('includes.admin.form-both')

                {{ csrf_field() }}

                <div class="form-group">
                    <label for="strategy_title">{{ __('Strategy Title') }} *</label>
                    <input type="text" class="form-control" id="strategy_title" name="strategy_title"
                           placeholder="{{ __('Strategy Title') }}" value="{{ $ps->strategy_title }}" required>
                </div>

                <div class="form-group">
                    <label for="strategy_details">{{ __('Strategy Subtitle') }} *</label>
                    <input type="text" class="form-control" id="strategy_details" name="strategy_details"
                           placeholder="{{ __('Strategy Subtitle') }}" value="{{ $ps->strategy_details }}" required>
                </div>


                <div class="form-group">
                    <label>{{ __('Set Background Image') }} <small
                            class="small-font">({{ __('Preferred Size 1600 X 1100') }})</small></label>
                    <div class="wrapper-image-preview">
                        <div class="box">
                            <div class="back-preview-image"
                                 style="background-image: url({{$ps->strategy_banner ? asset('assets/images/'.$ps->strategy_banner) : asset('assets/images/placeholder.jpg') }});"></div>
                            <div class="upload-options">
                                <label class="img-upload-label" for="img-upload"> <i
                                        class="fas fa-camera"></i> {{ __('Upload Picture') }} </label>
                                <input id="img-upload" type="file" class="image-upload" name="strategy_banner"
                                       accept="image/*">
                            </div>
                        </div>
                    </div>
                </div>


                <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>

            </form>
        </div>
    </div>

@endsection
