@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Add New Gateway') }} <a class="btn btn-primary btn-rounded btn-sm"
                    href="{{ route('admin.payment.index') }}"><i class="fas fa-arrow-left"></i> {{ __('Back') }}</a>
            </h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Payment Gateway') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row justify-content-center mt-3">
        <div class="col-md-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Payment Gateway Form') }}</h6>
                </div>

                <div class="card-body">
                    <div class="gocover"
                        style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
                    </div>
                    <form class="geniusform" action="{{ route('admin.payment.store') }}" method="POST"
                        enctype="multipart/form-data">

                        @include('includes.admin.form-both')

                        {{ csrf_field() }}

                        <div class="form-group">
                            <label for="title">{{ __('Name') }}</label>
                            <input type="text" class="form-control" id="title" name="title"
                                placeholder="{{ __('Enter Name') }}" value="" required />
                        </div>

                        <div class="form-group">
                            <label for="title">{{ __('Logo') }}</label>
                            <input type="file" class="form-control form-control-file" id="logo" name="logo" />
                        </div>

                        <div class="form-group">
                            <label for="subtitle">{{ __('Subtitle') }}</label>
                            <input type="text" class="form-control" id="subtitle" name="subtitle"
                                placeholder="{{ __('Enter Subtitle') }}" value="" required />
                        </div>

                        <div class="form-group">
                            <label for="currency_id">{{ __('Currency') }}</label>
                            <select class="form-control js-example-basic-single mb-3" name="currency_id" required>
                                <option value="" selected>{{ __('Select Currency') }}</option>
                                @foreach ($currencies as $key => $data)
                                    <option value="{{ $data->id }}">{{ $data->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="deposit_switch">
                                <label class="custom-control-label" for="deposit_switch">Deposit</label>
                            </div>
                        </div>

                        <div class="d-none border rounded px-3 py-2 mb-4" id="deposit_settings">
                            <p class="font-weight-bold border-bottom mb-3">Deposit Settings</p>

                            <div class="form-group">
                                <label for="details">{{ __('Description') }}</label>
                                <textarea class="form-control summernote" id="details" name="details" rows="3"
                                    placeholder="{{ __('Description') }}"></textarea>
                            </div>

                            <div class="lang-tag-top-filds mt-4" id="lang-section">
                                <label for="instruction">{{ __('Additional Information') }}</label>
                            </div>

                            <div class="mb-3">
                                <a href="javascript:void(0);" id="lang-btn" class="add-fild-btn">&plus;
                                    {{ __('Add More Field') }}</a>
                            </div>
                        </div>


                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="withdraw_switch"
                                    name="withdraw_status" />
                                <label class="custom-control-label" for="withdraw_switch">Withdraw</label>
                            </div>
                        </div>

                        <div class="d-none border rounded px-3 py-2 mb-4" id="withdraw_settings">
                            <p class="font-weight-bold border-bottom mb-3">Withdraw Settings</p>

                            <div class="form-group">
                                <label for="withdraw_note">{{ __('Withdraw Note') }}</label>
                                <textarea class="form-control summernote" id="withdraw_note" rows="3" name="withdraw_note"
                                    placeholder="{{ __('Withdraw Note') }}"></textarea>
                            </div>

                            <div class="form-group">
                                <label for="inp-fixed">{{ __('Withdraw Fixed Fee') }}
                                    <small>({{ __('Leave 0 if you don\'t want to add fee') }})</small></label>
                                <input type="number" class="form-control" id="inp-fixed" step="any"
                                    placeholder="{{ __('Withdraw Fixed Fee') }}" name="withdraw_fee_fixed"
                                    value="">
                            </div>

                            <div class="form-group">
                                <label for="inp-percentage">{{ __('Withdraw Percentage Charge') }}
                                    <small>({{ __('Leave 0 if you don\'t want to add fee') }})</small></label>
                                <input type="number" class="form-control" id="inp-percentage"
                                    placeholder="{{ __('Withdraw Percentage Charge') }}" name="withdraw_fee_percentage"
                                    step="any" value="">
                            </div>
                        </div>

                        <div class="py-2">
                            <p class="font-weight-bold border-bottom mb-3">Fund Settings</p>

                            <div class="form-group">
                                <label for="fund_note">{{ __('Note') }}</label>
                                <textarea class="form-control summernote" id="fund_note" name="fund_note" rows="3"
                                    placeholder="{{ __('Fund Note') }}"></textarea>
                            </div>

                            <div class="form-group">
                                <label for="fund_available">{{ __('Available Amount') }}</label>
                                <input type="number" class="form-control" id="fund_available" step="any"
                                    placeholder="{{ __('Available Amount') }}" name="fund_available" value=""
                                    required>
                            </div>

                            <div class="form-group">
                                <label for="sending_rate">{{ __('Sending Rate') }}</label>
                                <input type="number" class="form-control" id="sending_rate"
                                    placeholder="{{ __('Sending Rate') }}" name="sending_rate" value=""
                                    step="any" required />
                            </div>

                            <div class="form-group">
                                <label for="receiving_rate">{{ __('Receiving Rate') }}</label>
                                <input type="number" class="form-control" id="receiving_rate"
                                    placeholder="{{ __('Receiving Rate') }}" name="receiving_rate" value=""
                                    step="any" required />
                            </div>

                            <div class="form-group">
                                <label for="min_limit">{{ __('Minimum Limit') }}</label>
                                <input type="number" class="form-control" id="min_limit" step="any"
                                    placeholder="{{ __('Minimum Limit') }}" name="min_limit" value="" required>
                            </div>

                            <div class="form-group">
                                <label for="max_limit">{{ __('Maximum Limit') }}</label>
                                <input type="number" class="form-control" id="max_limit" step="any"
                                    placeholder="{{ __('Maximum Limit') }}" name="max_limit" value="" required>
                            </div>

                            <div class="form-group">
                                <label for="deposit_charge">{{ __('Deposit Charge Percent') }}</label>
                                <input type="text" class="form-control" id="deposit_charge" step="any"
                                    placeholder="{{ __('Deposit Charge Percent') }}" name="deposit_charge" value="" required>
                            </div>

                                   <div class="form-group">
                                <label for="deposit_charge_fix">{{ __('Deposit Charge Fix') }}</label>
                                <input type="text" class="form-control" id="deposit_charge_fix" step="any"
                                    placeholder="{{ __('Deposit Charge Fix') }}" name="deposit_charge_fix" value="" required>
                            </div>

                        </div>

                        <button type="submit" id="submit-btn"
                            class="btn btn-primary w-100">{{ __('Submit') }}</button>

                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('scripts')
    <script type="text/javascript">
        'use strict';

        function isEmpty(el) {
            return !$.trim(el.html())
        }

        let id = 1;

        $("#lang-btn").on('click', function() {

            $("#lang-section").append(`<div class="lang-area mb-3">
          <span class="remove lang-remove"><i class="fas fa-times"></i></span>
          <div class="row">
            <div class="col-md-6">
              <input type="text" name="form_builder[${id}][field_name]" class="form-control" placeholder="{{ __('Field Name') }}">
            </div>

            <div class="col-md-3">
              <select name="form_builder[${id}][type]" class="form-control">
                  <option value="text"> Input </option>
                  <option value="textarea"> Textarea </option>
                  <option value="file"> File upload </option>
              </select>
            </div>

            <div class="col-md-3">
              <select name="form_builder[${id}][validation]" class="form-control">
                  <option value="required"> Required </option>
                  <option value="nullable">  Optional </option>
              </select>
            </div>
          </div>
      </div>`);
            id++;
        });

        $(document).on('click', '.lang-remove', function() {

            $(this.parentNode).remove();
            if (id && id > 1) {
                id--;
            }
            if (isEmpty($('#lang-section'))) {

                $("#lang-section").append(`<div class="lang-area mb-3">
            <span class="remove lang-remove"><i class="fas fa-times"></i></span>
            <div class="row">
              <div class="col-md-6">
                <input type="text" name="form_builder[1][field_name]" class="form-control" placeholder="{{ __('Field Name') }}">
              </div>

              <div class="col-md-3">
                <select name="form_builder[1][type]" class="form-control">
                    <option value="text"> Input </option>
                    <option value="textarea"> Textarea </option>
                    <option value="file"> File upload </option>
                </select>
              </div>

              <div class="col-md-3">
                <select name="form_builder[1][validation]" class="form-control">
                    <option value="required"> Required </option>
                    <option value="nullable">  Optional </option>
                </select>
              </div>
            </div>
          </div>`);
            }

        });

        $(document).on('change', '#withdraw_switch', function() {
            if ($(this).is(':checked')) {
                $('#withdraw_settings').removeClass('d-none');
            } else {
                $('#withdraw_settings').addClass('d-none');
            }
        });

        $(document).on('change', '#deposit_switch', function() {
            if ($(this).is(':checked')) {
                $('#deposit_settings').removeClass('d-none');
            } else {
                $('#deposit_settings').addClass('d-none');
            }
        });
    </script>
@endsection
