@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Payment Gateways / Funds') }}</h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.payment.index') }}">{{ __('Payment Gateways') }}</a></li>
            </ol>
        </div>
    </div>


    <!-- Row -->
    <div class="row mt-3">
        <!-- Datatables -->
        <div class="col-lg-12">

            @include('includes.admin.form-success')

            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                            <tr>
                                <th width="">{{ __('Logo') }}</th>
                                <th width="30%">{{ __('Name') }}</th>
                                <th>{{ __('Currency') }}</th>
                                <th nowrap>{{ __('Available Amount') }}</th>
                                <th nowrap>{{ __('Deposit Status') }}</th>
                                <th nowrap>{{ __('Withdraw Status') }}</th>
                                <th nowrap>{{ __('Bank Plan Status') }}</th>
                                <th>{{ __('Options') }}</th>
                            </tr>
                            <tr class="dt-column-filter">
                                <th width=""></th>
                                <th class="px-2 py-1" width="30%">
                                    <input class="form-control form-control-sm mb-0" type="text"
                                        placeholder="{{ __('Search Name') }}">
                                </th>
                                <th class="px-2 py-1">
                                    <select class="form-control form-control-sm mb-0">
                                        <option value="">{{ __('All') }}</option>
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->name }}">{{ $currency->name }}</option>
                                        @endforeach
                                    </select>
                                </th>
                                <th class="px-2 py-1"><input class="form-control form-control-sm mb-0" type="text"
                                        placeholder="{{ __('Available Amount') }}"></th>
                                <th class="px-2 py-1">
                                    <select class="form-control form-control-sm mb-0">
                                        <option value="">{{ __('All') }}</option>
                                        <option value="1">{{ __('Active') }}</option>
                                        <option value="0">{{ __('Deactive') }}</option>
                                    </select>
                                </th>
                                <th class="px-2 py-1">
                                    <select class="form-control form-control-sm mb-0">
                                        <option value="">{{ __('All') }}</option>
                                        <option value="1">{{ __('Active') }}</option>
                                        <option value="0">{{ __('Deactive') }}</option>
                                    </select>
                                </th>
                                <th class="px-2 py-1">
                                    <select class="form-control form-control-sm mb-0">
                                        <option value="">{{ __('All') }}</option>
                                        <option value="1">{{ __('Active') }}</option>
                                        <option value="0">{{ __('Deactive') }}</option>
                                    </select>
                                </th>
                                <th class="px-2 py-1"></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!-- DataTable with Hover -->

    </div>
    <!--Row-->


    {{-- STATUS MODAL --}}

    <div class="modal fade confirm-modal" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="statusModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Update Status') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __('You are about to change the status.') }}</p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-success btn-ok">{{ __('Update') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- STATUS MODAL ENDS --}}


    {{-- DELETE MODAL --}}

    <div class="modal fade confirm-modal" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Confirm Delete') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __('You are about to delete this Payment.') }}</p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-danger btn-ok">{{ __('Delete') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- DELETE MODAL ENDS --}}
@endsection



@section('scripts')
    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '{{ route('admin.payment.datatables') }}',
            columns: [{
                    data: 'logo',
                    name: 'logo',
                    searchable: false,
                    orderable: false,
                },
                {
                    data: 'title',
                    name: 'title'
                },
                {
                    data: 'currency',
                    name: 'currency',
                    className: 'text-center white-space-nowrap',
                },
                {
                    data: 'fund_available',
                    searchable: false,
                    orderable: false,
                    className: 'text-right'
                },
                {
                    data: 'status',
                },
                {
                    data: 'withdraw_status',
                },
                {
                    data: 'bank_plan_status',
                },
                {
                    data: 'action',
                    searchable: false,
                    orderable: false
                }

            ],
            language: {
                processing: 'Loading...'
            }
        });

        // Apply column filter
        $('#geniustable .dt-column-filter th').each(function(i) {
            $('input, select', this).on('keyup change', debounce(function() {
                if (table.column(i).search() !== this.value) {
                    table.column(i).search(this.value).draw()
                }
            }, 300)); // 300ms debounce delay
        });

        $(function() {
            $(".btn-area").append('<div class="col-sm-12 col-md-4 text-right">' +
                '<a class="btn btn-primary mr-2" href="{{ route('admin.payment.sort') }}">' +
                '<i class="fas fa-sort"></i> {{ __('Sort') }}' +
                '</a>' +
                '<a class="btn btn-primary" href="{{ route('admin.payment.create') }}">' +
                '<i class="fas fa-plus"></i> {{ __('Add New') }}' +
                '</a>' +
                '</div>');
        });
    </script>
@endsection
