@extends('layouts.admin')

@section('styles')
    <style>
        .sortable-ghost {
            background-color: #f8f9fc !important;
            opacity: 0.8;
        }

        .sortable-item {
            cursor: pointer;
        }

        .sortable-item:hover {
            background-color: #f8f9fc;
        }

        .handle {
            color: #6c757d;
        }

        .handle:hover {
            color: #007bff;
        }
    </style>
@endsection

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">
                <a class="btn btn-primary btn-rounded btn-sm" href="{{route('admin.payment.index')}}"><i
                        class="fas fa-arrow-left"></i> {{ __('Back') }}</a>
                {{ __('Sort Payment Gateways / Funds') }}
            </h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ route('admin.payment.index') }}">{{ __('Payment Gateways') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.payment.sort') }}">{{ __('Sort') }}</a></li>
            </ol>
        </div>
    </div>


    <!-- Row -->
    <div class="row mt-3">
        <!-- Datatables -->
        <div class="col-lg-12">

            @include('includes.admin.form-success')

            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                        <tr>
                            <th></th>
                            <th width="">{{ __('Logo') }}</th>
                            <th width="30%">{{ __('Name') }}</th>
                            <th>{{ __('Sort Order') }}</th>
                        </tr>
                        </thead>
                        <tbody id="sortable-table">
                        @foreach($items as $item)
                            <tr class="sortable-item handle" data-id="{{ $item->id }}">
                                <td>
                                    <i class="fas fa-arrows-alt handle ml-2" style="cursor: move;"></i>
                                </td>
                                <td>
                                    @if($item->logo != null)
                                        <img src="{{ asset('assets/images/'.$item->logo) }}" alt="Image" width="50">
                                    @else
                                        <img src="{{ asset('assets/images/placeholder.png') }}" alt="Image" width="50">
                                    @endif
                                </td>
                                <td>{{ $item->name ?? $item->title }}</td>
                                <td>
                                    <span class="sorting-order">{{ $item->sorting_order }}</span>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    <div class="text-center mt-3">
                        <button type="button" class="btn btn-primary" id="save-order">{{ __('Save Order') }}</button>
                    </div>
                </div>
            </div>
        </div>


    </div>

@endsection



@section('scripts')

    <script type="text/javascript">
        "use strict";

        $(document).ready(function () {
            // Initialize Sortable.js on the table body
            var sortable = Sortable.create(document.getElementById('sortable-table'), {
                animation: 150,
                handle: '.handle',
                ghostClass: 'bg-light',
                onEnd: function () {
                    // Update the sorting order numbers after drag
                    updateSortingNumbers();
                }
            });

            // Function to update the sorting order numbers
            function updateSortingNumbers() {
                $('.sortable-item').each(function (index) {
                    $(this).find('.sorting-order').text(index + 1);
                });
            }

            // Save the order when the save button is clicked
            $('#save-order').on('click', function () {
                var ids = [];
                $('.sortable-item').each(function () {
                    ids.push($(this).data('id'));
                });

                $.ajax({
                    url: '{{ route("admin.payment.sort.update") }}',
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        ids: ids
                    },
                    success: function (response) {
                        if (response.success) {
                            $('.status-modal').modal('hide');
                            $('.alert-danger').hide();
                            $('.alert-success').show();
                            $('.alert-success p').html("{{ __('Payment gateways sorted successfully.') }}");
                        } else {
                            $.notify('Error occurred while saving order', "error");
                        }
                    },
                    error: function () {
                        $.notify('Error occurred while saving order', "error");
                    }
                });
            });
        });
    </script>
@endsection
