@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Report of Profit From Charges') }}</h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Profit From Charge') }}</a></li>
            </ol>
        </div>
    </div>


    <!-- Row -->
    <div class="row mt-3">
        <div class="col-lg-12">
            @include('includes.admin.form-success')
            <div class="card mb-4">
                <div class="p-3">
                    <div class="row">
                        <div class="col-lg-12">
                            <form action="{{ route('admin.reports.profit-from-charge') }}" method="get">
                                <div class="d-flex align-items-center">
                                    <div class="mr-2 d-inline-flex align-items-center">
                                        <label class="form-label mb-0 mr-2">{{ __('From') }}:</label>
                                        <input type="date" class="input-field mb-0" name="from" value="{{$from}}" required>
                                    </div>
                                    <div class="mr-2 d-inline-flex align-items-center">
                                        <label class="form-label mb-0 mr-2">{{ __('To') }}:</label>
                                        <input type="date" class="input-field mb-0" name="to" value="{{$to}}" required>
                                    </div>
                                    <div class="mt-auto">
                                        <button type="submit" id="submit-btn"
                                            class="btn btn-primary w-100">{{ __('Submit') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="px-3 pt-3 pb-0">
                    <h4 class="text-center">{{ __('Profit From Charges') }}</h4>
                    <p class="text-center">{{ __('From') }} {{ date('d-m-Y', strtotime($from)) }} {{ __('To') }}
                        {{ date('d-m-Y', strtotime($to)) }}</p>
                </div>
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                            <tr class="dt-column-filter">
                                <th class="w-1"></th>
                                <th class="pb-3">
                                    <div class="dropdown m-0 p-0">
                                        <button class="form-control dropdown-toggle " type="button"
                                            data-toggle="dropdown">
                                            Select Type
                                        </button>
                                        <div class="dropdown-menu " style="max-height: 300px; overflow-y: auto;">
                                            <label class="dropdown-item">
                                                <input type="checkbox" class="filter-type" value="Send Money"> Send Money
                                            </label>
                                            <label class="dropdown-item">
                                                <input type="checkbox" class="filter-type" value="Referral Bonus"> Referral
                                                Bonus
                                            </label>
                                            <label class="dropdown-item">
                                                <input type="checkbox" class="filter-type" value="Deposit"> Deposit
                                            </label>
                                            <label class="dropdown-item">
                                                <input type="checkbox" class="filter-type" value="Bonus Money"> Bonus Money
                                            </label>
                                            <label class="dropdown-item">
                                                <input type="checkbox" class="filter-type" value="Bank Plan"> Bank Plan
                                            </label>
                                            <label class="dropdown-item">
                                                <input type="checkbox" class="filter-type" value="Withdraw"> Withdraw
                                            </label>
                                            <label class="dropdown-item">
                                                <input type="checkbox" class="filter-type" value="Request"> Request
                                            </label>
                                        </div>
                                    </div>
                                </th>
                                <th>
                                    <input type="text" class="form-control" placeholder="name" />
                                </th>

                                <th>
                                    <input type="text" class="form-control" placeholder="trx id" />
                                </th>
                                <th>

                                </th>
                                <th>

                                </th>

                                <th></th>
                            </tr>
                            <tr>
                                <th>{{ __('S/N') }}</th>
                                <th>{{ __('Transaction Type') }}</th>
                                <th>{{ __('Customer Name') }}</th>
                                <th>{{ __('Txnid') }}</th>
                                <th>{{ __('Date') }}</th>
                                <th>{{ __('Debit') }}</th>
                                <th>{{ __('Credit') }}</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>{{ __('Total') }}:</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection



@section('styles')
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap4.min.css">
    <style>
        .dt-buttons {
            margin-bottom: 15px;
        }

        .dt-buttons .dt-button {
            margin-right: 5px;
            padding: 5px 15px;
            border-radius: 4px;
            background-color: #6777ef;
            color: #fff;
            border: none;
            cursor: pointer;
        }

        .dt-buttons .dt-button:hover {
            background-color: #5a6bc0;
        }
    </style>
@endsection

@section('scripts')
    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.70/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.70/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>



    <script type="text/javascript">
        "use strict";
        var table = $('#geniustable').DataTable({
            ordering: true,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '{!! request()->fullUrl() !!}',
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'customer_name',
                    name: 'customer_name'
                },
                {
                    data: 'txnid',
                    name: 'txnid'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'debit',
                    name: 'debit',
                    className: "text-right"
                },
                {
                    data: 'credit',
                    name: 'credit',
                    className: "text-right"
                },
            ],
            order: [
                [4, 'desc']
            ],


            // Page length dropdown options
            lengthMenu: [
                [20, 50, 100, -1],
                [20, 50, 100, "All"]
            ],
            pageLength: 20,

            dom: '<"row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"B><"col-sm-12 col-md-4"f>>rtip',

            buttons: [{
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    title: '{{ __("Report of Profit From Charges") }}',
                    exportOptions: {
                        columns: [0,1,2,3,4,5,6],
                        stripHtml: true
                    },
                    footer: true,
                    orientation: 'landscape',
                    pageSize: 'A4',
                    customize: function (doc) {
                        if (doc.content[1] && doc.content[1].table) {
                            var colCount = doc.content[1].table.body[0].length;
                            doc.content[1].table.widths = new Array(colCount).fill('*');
                        }
                        doc.styles.tableHeader.alignment = 'center';
                        doc.defaultStyle.alignment = 'center';
                    }
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    title: '{{ __('Report of Profit From Charges') }}',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    },
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Print',
                    title: '{{ __('Report of Profit From Charges') }}',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    },
                    footer: true,
                    customize: function(win) {
                        $(win.document.body).css('font-size', '10pt');
                        $(win.document.body).find('table')
                            .addClass('compact')
                            .css('font-size', 'inherit');
                    }
                }
            ],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            },

            footerCallback: function(row, data, start, end, display) {
                var api = this.api();

                var intVal = function(i) {
                    if (typeof i === 'string') {
                        // Remove HTML tags first, then commas, currency symbols, spaces
                        i = i.replace(/<[^>]*>/g, '') // remove HTML tags
                            .replace(/[\₹,]/g, '') // remove currency symbols and commas
                            .trim(); // remove extra spaces
                        return parseFloat(i) || 0;
                    } else if (typeof i === 'number') {
                        return i;
                    }
                    return 0;
                };

                // Debit total (column index 5)
                var debitTotal = api
                    .column(5, {
                        page: 'current'
                    })
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Credit total (column index 6)
                var creditTotal = api
                    .column(6, {
                        page: 'current'
                    })
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Profit = Credit - Debit
                var profit = creditTotal - debitTotal;

                // Show totals in their own cells
                $(api.column(5).footer()).html('{{ __('Total') }}: ' + debitTotal.toFixed(2));
                $(api.column(6).footer()).html('{{ __('Total') }}: ' + creditTotal.toFixed(2));

                // Add profit display below the table
                $('#profitFooter').remove(); // remove old profit row if exists
                $('#geniustable').after(
                    '<div id="profitFooter" class="mt-2 font-weight-bold text-right">' +
                    '{{ __('Profit') }}: ' + profit.toFixed(2) +
                    '</div>'
                );
            }

        });

        //new added started
        $(document).on('change', '.filter-type', function() {
            let selectedTypes = [];
            $('.filter-type:checked').each(function() {
                selectedTypes.push($(this).val());
            });

            let searchRegex = selectedTypes.join('|'); // OR search
            table.column(1).search(searchRegex, true, false).draw();
        });
        //new added end

        // Bind column search fields
        $('#geniustable thead tr.dt-column-filter th').each(function(i) {
            $('input, select', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table.column(i).search(this.value).draw();
                }
            });
        });
    </script>
@endsection
