@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Edit Role') }} <a class="btn btn-primary btn-rounded btn-sm"
                                                                          href="{{route('admin.role.index')}}"><i
                        class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Roles') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.role.index') }}">{{ __('Manage Roles') }}</a></li>
                <li class="breadcrumb-item"><a href="{{route('admin.role.edit',$data->id)}}">{{ __('Edit Role') }}</a>
                </li>
            </ol>
        </div>
    </div>

    <div class="row justify-content-center mt-3">
        <div class="col-md-10">
            <!-- Form Basic -->
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Edit Role Form') }}</h6>
                </div>

                <div class="card-body">
                    <div class="gocover"
                         style="background: url({{asset('assets/images/'.$gs->admin_loader)}}) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
                    <form class="geniusform" action="{{route('admin.role.update',$data->id)}}" method="POST"
                          enctype="multipart/form-data">

                        @include('includes.admin.form-both')

                        {{ csrf_field() }}

                        <div class="form-group">
                            <label for="inp-name">{{ __('Role Name') }}</label>
                            <input type="text" class="form-control" id="inp-name" name="name"
                                   placeholder="{{ __('Enter Role Name') }}" value="{{$data->name}}" required>
                        </div>


                        <hr>

                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="all_option"/>
                                <label class="custom-control-label" for="all_option">All</label>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            @foreach($sections as $section)
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="custom-control custom-switch">
                                            <input
                                                type="checkbox"
                                                name="section[]"
                                                value="{{$section['name']}}"
                                                class="custom-control-input"
                                                id="{{Str::slug($section['name'], '_')}}"
                                                data-parent
                                                @checked($data->sectionCheck($section['name']))
                                            />
                                            <label class="custom-control-label"
                                                   for="{{Str::slug($section['name'], '_')}}">{{__($section['name'])}}</label>
                                        </div>
                                    </div>
                                    @if(count($section['children']) > 0)
                                        <div class="pl-4">
                                            @foreach($section['children'] as $child)
                                                <div class="form-group">
                                                    <div class="custom-control custom-switch">
                                                        <input
                                                            type="checkbox"
                                                            name="section[]"
                                                            value="{{$child['name']}}"
                                                            class="custom-control-input"
                                                            id="{{Str::slug($child['name'], '_')}}"
                                                            data-child-of="{{Str::slug($section['name'], '_')}}"
                                                            @checked($data->sectionCheck($child['name']))
                                                        />
                                                        <label class="custom-control-label"
                                                               for="{{Str::slug($child['name'], '_')}}">{{__($child['name'])}}</label>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>

                        <hr>

                        <button type="submit" id="submit-btn"
                                class="btn btn-primary w-100">{{ __('Submit') }}</button>

                    </form>
                </div>
            </div>
        </div>

    </div>
    <!--Row-->

@endsection

@section('scripts')
    <script>
        $(function () {
            $("input[data-parent]").on("change", function () {
                const parentId = $(this).attr("id");
                const propChecked = $(this).prop("checked");

                $(`input[data-child-of="${parentId}"]`).prop("checked", propChecked);
            });

            $("#all_option").on("change", function () {
                const propChecked = $(this).prop("checked");
                $("input[type=checkbox]").prop("checked", propChecked);
            });
        });
    </script>
@endsection
