@extends('layouts.admin')

@section('content')
    <div class="card mb-4">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('User List') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>

                <li class="breadcrumb-item"><a href="{{ route('admin.user.logs') }}">{{ __('User Login Logs') }}</a></li>
            </ol>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            {{-- <h5 class="mb-3">{{ __('User Login Logs') }}</h5> --}}
            <div class="table-responsive">
                <table id="geniustable" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>{{ __('ID') }}</th>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('Email') }}</th>
                            <th>{{ __('Phone') }}</th>
                            <th>{{ __('IP Address') }}</th>
                            <th>{{ __('Device') }}</th>
                            <th>{{ __('Browser') }}</th>
                            <th>{{ __('Location') }}</th>
                            <th>{{ __('Coordinates') }}</th>
                            <th>{{ __('Date') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    @if($multipulUsersameIp->count())
    <div class="card mt-5">
        <div class="card-header">
           <h4> {{ __(' Same Ip Multipul User List') }}</h4>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>{{ __('IP Address') }}</th>
                        <th>{{ __('Users Sharing IP') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($multipulUsersameIp as $ip)
                        <tr>
                            <td>{{ $ip->ip }}</td>
                            <td>
                                @php
                                    $users = \App\Models\LoginLogs::with('user')
                                        ->where('ip', $ip->ip)
                                        ->get()
                                        ->pluck('user.name')
                                        ->unique();
                                @endphp
                                {{ $users->join(', ') }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
    @endif
@endsection

@section('scripts')
    <script>
        $(function() {
            $('#geniustable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('admin.user.logs.search') }}',
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'name',
                        name: 'user.name'
                    },
                    {
                        data: 'email',
                        name: 'user.email'
                    },
                    {
                        data: 'phone',
                        name: 'user.phone'
                    },
                    {
                        data: 'ip',
                        name: 'ip'
                    },
                    {
                        data: 'device',
                        name: 'device'
                    },
                    {
                        data: 'browser',
                        name: 'browser'
                    },
                    {
                        data: 'location',
                        name: 'city'
                    },
                    {
                        data: 'coordinates',
                        name: 'latitude'
                    },
                    {
                        data: 'date',
                        name: 'created_at'
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });
    </script>
@endsection
