@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('User List') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>

                <li class="breadcrumb-item"><a href="{{ route('admin.user.index') }}">{{ __('User List') }}</a></li>
            </ol>
        </div>
    </div>


    <!-- Row -->
    <div class="row mt-3">
        <!-- Datatables -->
        <div class="col-lg-12">

            @include('includes.admin.form-success')

            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover" cellspacing="0" width="100%">
                        <thead class="thead-light">
                            <tr class="dt-column-filter">
                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('ID') }}" />
                                </th>
                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('Search Name') }}" />
                                </th>
                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('Search Email') }}">
                                </th>
                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('Search Phone') }}">
                                </th>
                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('Search Acount') }}">
                                </th>
                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('Search Balance') }}">
                                </th>
                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('Loan Balance') }}">
                                </th>

                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('Dps Balance') }}">
                                </th>

                                <th class="px-2 py-1">
                                    <input type="text" class="form-control form-control-sm mb-0"
                                        placeholder="{{ __('Fdr Balance') }}">
                                </th>
                                <th class="px-2 py-1">
                                    <select type="text" class="form-control form-control-sm mb-0">
                                        <option value="">All</option>
                                        <option value="personal">Personal</option>
                                        <option value="agent">Agent</option>
                                        <option value="merchant">Merchant</option>
                                    </select>
                                </th>
                                <th class="px-2 py-1">
                                    {{-- <select class="form-control form-control-sm mb-0">
                                    <option value="">All</option>
                                    <option value="1">Block</option>
                                    <option value="0">Unblock</option>
                                </select> --}}
                                </th>
                                <th class="px-2 py-1">
                                    {{-- <select class="form-control form-control-sm mb-0">
                                    <option value="">All</option>
                                    <option value="0">Suspended</option>
                                    <option value="1">Unsuspended</option>
                                </select> --}}
                                </th>
                                <th></th>
                            </tr>
                            <tr>
                                <th>{{ __('ID#') }}</th>
                                <th nowrap>{{ __('Name') }}</th>
                                <th nowrap>{{ __('Email') }}</th>
                                <th nowrap>{{ __('Phone') }}</th>
                                <th nowrap>{{ __('Account') }}</th>
                                <th nowrap class="text-right">{{ __('Balance') }}</th>
                                <th nowrap class="text-right">{{ __('Loan Amount') }}</th>
                                <th nowrap class="text-right">{{ __('Dps Smount') }}</th>
                                <th nowrap class="text-right">{{ __('Fdr Amount') }}</th>
                                <th nowrap class="text-right">{{ __('Bonus Point') }}</th>
                                <th nowrap>{{ __('Account Type') }}</th>
                                <th nowrap>{{ __('Block Status') }}</th>
                                <th nowrap>{{ __('Suspend Status') }}</th>
                                <th>{{ __('Options') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!-- DataTable with Hover -->

    </div>
    <!--Row-->

    {{-- STATUS MODAL --}}

    <div class="modal fade confirm-modal" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="statusModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Update Status') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __('You are about to change the status.') }}</p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-success btn-ok">{{ __('Update') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- STATUS MODAL ENDS --}}

    {{-- ATTRIBUTE MODAL --}}
    <div class="modal fade" id="attribute" tabindex="-1" role="dialog" aria-labelledby="attribute" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="submit-loader">
                    <img src="{{ asset('assets/images/' . $gs->admin_loader) }}" alt="">
                </div>

                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('Close') }}</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade confirm-modal" id="deleteModal" tabindex="-1" role="dialog"
        aria-labelledby="deleteModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Confirm Delete') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">
                        {{ __('You are about to delete this User. Every informtation under this user will be deleted.') }}
                    </p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-danger btn-ok">{{ __('Delete') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- SUSPEND MODAL --}}

    <div class="modal fade confirm-modal" id="suspendModal" tabindex="-1" role="dialog"
        aria-labelledby="suspendModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="{{ route('admin-user-suspend') }}" method="POST">
                    {{ csrf_field() }}
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('Update Status') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p class="text-center">{{ __('You are about to suspend the user.') }}</p>
                        <label for="" class="form-control-label">Suspend Reason</label>
                        <textarea class="form-control" name="suspend_reason" placeholder="Write Suspend Reason" required></textarea>
                        <input type="hidden" name="user_id" id="suspend_user_id">
                    </div>
                    <div class="modal-footer">
                        <a href="javascript:void(0)" class="btn btn-secondary"
                            data-dismiss="modal">{{ __('Cancel') }}</a>
                        <button type="submit" class="btn btn-success btn-suspend">{{ __('Suspend') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- SUSPEND MODAL ENDS --}}

    {{-- UNSUSPEND MODAL --}}

    <div class="modal fade confirm-modal" id="unsuspendModal" tabindex="-1" role="dialog"
        aria-labelledby="unsuspendModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="{{ route('admin-user-unsuspend') }}" method="POST">
                    {{ csrf_field() }}
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('Update Status') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p class="text-center">{{ __('You are going to unsuspend the user.') }}</p>
                        <input type="hidden" name="user_id" id="unsuspend_user_id">
                    </div>
                    <div class="modal-footer">
                        <a href="javascript:void(0)" class="btn btn-secondary"
                            data-dismiss="modal">{{ __('Cancel') }}</a>
                        <button type="submit" class="btn btn-success">{{ __('Unsuspend') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- UNSUSPEND MODAL ENDS --}}


    <div class="sub-categori">
        <div class="modal fade confirm-modal" id="vendorform" tabindex="-1" role="dialog"
            aria-labelledby="vendorformLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="vendorformLabel">{{ __('Send Message') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid p-0">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="contact-form">
                                        <form id="emailreply1">
                                            {{ csrf_field() }}

                                            <div class="form-group">
                                                <input type="email" class="form-control" id="eml1" name="to"
                                                    placeholder="{{ __('Email') }}" readonly value=""
                                                    required="">
                                            </div>

                                            <div class="form-group">
                                                <input type="text" class="form-control" id="subj1" name="subject"
                                                    placeholder="{{ __('Subject') }}" value="" required="">
                                            </div>

                                            <div class="form-group">
                                                <textarea class="form-control" name="message" id="msg1" cols="20" rows="6"
                                                    placeholder="{{ __('Your Message') }} " required=""></textarea>
                                            </div>

                                            <button class="submit-btn btn btn-primary text-center" id="emlsub1"
                                                type="submit">{{ __('Send Message') }}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade confirm-modal" id="loginModal" tabindex="-1" role="dialog"
        aria-labelledby="loginModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Login to user') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __('Are you sure?') }}</p>
                    <p class="text-center">{{ __('You want to login to user account of ') }} <br>
                        <span id="loginUserName"></span>?
                    </p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                    <form action="{{ route('admin.login-to-user') }}" method="POST" target="_blank" class="d-none"
                        id="loginToUserForm">
                        {{ csrf_field() }}
                        <input name="user_id" value type="hidden" id="loginUserId" />
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal">{{ __('No, Cancel') }}</button>
                    <button type="submit" class="btn btn-success"
                        form="loginToUserForm">{{ __('Yes, Login') }}</button>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('scripts')
    <script type="text/javascript">
        'use strict';

        var table = $('#geniustable').DataTable({
            //ordering: true,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '{{ route('admin-user-datatables') }}',
            columns: [{
                    data: 'id',
                    name: 'id',
                    orderable: true
                },
                {
                    data: 'full_name',
                    name: 'name',
                    orderable: true,
                    className: 'white-space-nowrap'
                },
                {
                    data: 'email',
                    name: 'email',
                    orderable: true,
                    className: 'white-space-nowrap'
                },
                {
                    data: 'phone',
                    name: 'phone',
                    orderable: true,
                    className: 'white-space-nowrap'
                },
                {
                    data: 'account_number',
                    name: 'account_number',
                    orderable: true,
                    className: 'white-space-nowrap'
                },
                {
                    data: 'balance',
                    name: 'balance',
                    className: 'text-right',
                    orderable: true
                },
                {
                    data: 'loan_amount',
                    name: 'loan_amount',
                    className: 'text-right',
                    orderable: true,
                    searchable: true
                },
                {
                    data: 'dps_amount',
                    name: 'dps_amount',
                    className: 'text-right',
                    orderable: true,
                    searchable: true
                },
                {
                    data: 'fdr_amount',
                    name: 'fdr_amount',
                    className: 'text-right',
                    orderable: true,
                    searchable: true
                },
                {
                    data: 'bonus_point',
                    name: 'bonus_point',
                    className: 'text-right',
                    orderable: true,
                    searchable: true
                },
                {
                    data: 'account_type',
                    searchable: true
                },
                {
                    data: 'status',
                    orderable: false,
                    searchable: true
                },
                {
                    data: 'suspend',
                    orderable: false,
                    searchable: true
                },
                {
                    data: 'action',
                    searchable: false,
                    orderable: false
                }
            ],
            order: [
                [0, 'desc']
            ],
            drawCallback: function() {
                $('[data-toggle="tooltip"]').tooltip()
            },
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            }
        });

        // Apply column filter
        $('#geniustable .dt-column-filter th').each(function(i) {
            $('input, select', this).on('keyup change', debounce(function() {
                if (table.column(i).search() !== this.value) {
                    table.column(i).search(this.value).draw()
                }
            }, 300));
        });
    </script>

    <script>
        $(function() {
            $(document).on('click', '.suspend-user', function(e) {
                $('#suspendModal').modal('show');
                $('#suspend_user_id').val($(this).data('user-id'));
            });
            $(document).on('click', '.unsuspend-user', function(e) {
                $('#unsuspendModal').modal('show');
                $('#unsuspend_user_id').val($(this).data('user-id'));
            });
            $(document).on('click', '.login-to-user', function() {
                let userId = $(this).data('id');
                let userName = $(this).data('name');
                let userEmail = $(this).data('email');
                $("#loginUserId").val(userId);
                $("#loginUserName").html(`${userName} (${userEmail})`);
                $("#loginModal").modal("show");
            });
            $(document).on('submit', '#loginToUserForm', function() {
                $("#loginModal").modal("hide");
                return true;
            });
        });
    </script>
@endsection
