@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Wire Transfer') }}</h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ route('admin.wire.transfer.index') }}">{{ __('Wire Transfer') }}</a></li>
            </ol>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-lg-12">
            @include('includes.admin.form-success')
            <div class="card mb-4">
                <div class="d-flex align-items-center mt-2">
                    <!-- Print Button -->
                    <a id="print-selected" target="_blank" class="btn btn-primary mx-2"
                        href="{{ route('admin.wire.transfer.pdfprint') }}">
                        <i class="fas fa-print"></i> Print
                    </a>

                    <div class="dropdown mx-2">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="statusDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                            <span id="statusDropdownLabel">Change Status</span>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="statusDropdown">
                            <li><a href="javascript:;" class="dropdown-item change-status" data-status="0">{{ __('Pending') }}</a></li>
                            <li><a href="javascript:;" class="dropdown-item change-status" data-status="1">{{ __('Completed') }}</a></li>
                            <li><a href="javascript:;" class="dropdown-item change-status" data-status="3">{{ __('Processing') }}</a></li>
                            <li><a href="javascript:;" class="dropdown-item change-status" data-status="4">{{ __('Hold') }}</a></li>
                            <li><a href="javascript:;" class="dropdown-item change-status text-danger" data-status="2">{{ __('Rejected') }}</a></li>
                        </ul>
                    </div>
                </div>

                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                            <tr class="dt-column-filter">
                                <th></th>
                                <th></th>
                                <th>
                                    <select type="text" id="bank-filter" class="form-control ">
                                        <option value="">Select Bank</option>
                                        @foreach ($banks as $bank)
                                            <option value="{{ $bank->id }}">{{ $bank->title }}</option>
                                        @endforeach
                                    </select>
                                </th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>
                                    <select type="text" id="country-filter" class="form-control ">
                                        <option value="">Select Country</option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->name }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </th>
                                <th>
                                    <select type="text" id="status-filter" class="form-control ">
                                        <option value="">Select Status</option>
                                        <option value="0">Pending</option>
                                        <option value="3">Processing</option>
                                        <option value="1">Completed</option>
                                        <option value="4">Hold</option>
                                        <option value="2">Rejected</option>
                                    </select>
                                </th>
                                <th></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th><input type="checkbox" id="select-all"></th>
                                <th>{{__('Transaction no')}}</th>
                                <th>{{__('Bank Name')}}</th>
                                <th>{{__('Transfer From')}}</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>{{__('Recever Details')}}</th>
                                <th>{{__('Amount')}}</th>
                                <th>{{__('Charge')}}</th>
                                <th>{{__('Country')}}</th>
                                <th>{{__('Status')}}</th>
                                <th> {{ __('Last Status') }} </th>
                                <th>{{__('Options')}}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    {{-- STATUS MODAL --}}
    <div class="modal fade confirm-modal" id="statusModal" tabindex="-1" role="dialog"
         aria-labelledby="statusModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __("Update Status") }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __("You are about to change the status.") }}</p>
                    <p class="text-center">{{ __("Do you want to proceed?") }}</p>
                </div>

                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __("Cancel") }}</a>
                    <a href="javascript:;" class="btn btn-success btn-ok">{{ __("Update") }}</a>
                </div>
            </div>
        </div>
    </div>
    {{-- STATUS MODAL ENDS --}}

@endsection


@section('scripts')

    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: {
                url: "{{ route('admin.wire.transfer.datatables') }}",
                data: function(d) {
                    d.bank = $('#bank-filter').val();
                    d.country = $('#country-filter').val();
                    d.status = $('#status-filter').val();
                }
            },
            columns: [
                {data: 'checkbox', name: 'checkbox', orderable: false, searchable: false},
                {data: 'transaction_no', name: 'transaction_no'},
                {data: 'wire_transfer_bank_id', name: 'bank.title'},
                {data: 'user_name', name: 'user.name', visible: false, searchable: true},
                {data: 'acc', name: 'user.account_number', visible: false, searchable: true},
                {data: 'acc_name', name: 'account_holder_name', visible: false, searchable: true},
                {data: 'user_id', name: 'user_id'},
                {data: 'account_number', name: 'account_number'},
                {data: 'amount', name: 'amount'},
                {data: 'charge_amount', name: 'charge'},
                {data: 'country', name: 'country'},
                {data: 'status', name: 'status'},
                {data: 'status_last_history', name: 'lastHistory.admin.name'},
                {data: 'action', searchable: false, orderable: false}
            ],
            language: {
                processing: '<img src="{{asset('assets/images/'.$gs->admin_loader)}}">'
            }
        });

        $('#bank-filter, #country-filter, #status-filter').on('change', function() {
            table.draw();
        });
    </script>
    <script>
        function closeStatusDropdown() {
            const btn = document.getElementById('statusDropdown');

            if (window.bootstrap && bootstrap.Dropdown) {
                try {
                const inst = (bootstrap.Dropdown.getOrCreateInstance)
                    ? bootstrap.Dropdown.getOrCreateInstance(btn)
                    : (bootstrap.Dropdown.getInstance ? bootstrap.Dropdown.getInstance(btn) : null);
                if (inst && typeof inst.hide === 'function') {
                    inst.hide();
                    return;
                }
                } catch (err) {
                }
            }

            if (typeof $ === 'function' && $.fn && typeof $.fn.dropdown === 'function') {
                try {
                $(btn).dropdown('toggle');
                $(btn).parent('.dropdown').removeClass('show').find('.dropdown-menu').removeClass('show');
                return;
                } catch (err) {

                }
            }

            document.querySelectorAll('.dropdown.show, .dropdown-menu.show').forEach(el => el.classList.remove('show'));
        }

        function getSelectedIds() {
            return $('.row-checkbox:checked').map(function() { return $(this).val(); }).get();
        }

        $(document).on('click', '.change-status', function(e) {
            e.preventDefault();

            const status = $(this).data('status');
            const label = $(this).text().trim();
            const ids = getSelectedIds();

            if (ids.length === 0) {
                alert('Please select at least one record to change status.');
                return;
            }

            if ($('#statusDropdownLabel').length) {
                $('#statusDropdownLabel').text(label);
            } else {
                $('#statusDropdown').text(label);
            }

            closeStatusDropdown();

            // send AJAX
            $.ajax({
                url: "{{ route('admin.wire.transfer.changeStatus') }}",
                type: "POST",
                data: {
                ids: ids,
                status: status,
                _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    $('#geniustable').DataTable().ajax.reload(null, false);
                     if (response.message) {
                            toastr.success(response.message);
                        }
                        if (response.notes && response.notes.length > 0) {
                            response.notes.forEach(function(note) {
                                toastr.info(note);
                            });
                        }
                },
                error: function(xhr) {
                    alert('Something went wrong. Please try again.');
                }
            });
        });
    </script>

    <script>
        // Select all checkboxes
        $('#select-all').on('click', function() {
            const isChecked = $(this).is(':checked');
            $('.row-checkbox').prop('checked', isChecked);
            printSelectedIds();
        });

        // When any checkbox is clicked
        $(document).on('change', '.row-checkbox', function() {
            const allChecked = $('.row-checkbox').length === $('.row-checkbox:checked').length;
            $('#select-all').prop('checked', allChecked);
            printSelectedIds();
        });

        // Function to print selected IDs
        function printSelectedIds() {
            const ids = $('.row-checkbox:checked').map(function() {
                return $(this).val();
            }).get();
            console.log('Selected IDs:', ids);
        }
        // Select all checkboxes
        $('#select-all').on('click', function() {
            const isChecked = $(this).is(':checked');
            $('.row-checkbox').prop('checked', isChecked);
            printSelectedIds();
        });

        // When any checkbox is clicked
        $(document).on('change', '.row-checkbox', function() {
            const allChecked = $('.row-checkbox').length === $('.row-checkbox:checked').length;
            $('#select-all').prop('checked', allChecked);
            printSelectedIds();
        });

        // Function to print selected IDs
        function printSelectedIds() {
            const ids = $('.row-checkbox:checked').map(function() {
                return $(this).val();
            }).get();

        }
    </script>

    <script>
        function getSelectedIds() {
            return $('.row-checkbox:checked').map(function() {
                return $(this).val();
            }).get();
        }

        $('#print-selected').on('click', function(e) {
            const ids = getSelectedIds();

            if (ids.length > 0) {
                const queryString = ids.map(id => `ids[]=${id}`).join('&');
                const baseUrl = `{{ route('admin.wire.transfer.pdfprint') }}`;
                const url = `${baseUrl}?${queryString}`;
                $(this).attr('href', url);
            } else {
                
                $(this).attr('href', `{{ route('admin.wire.transfer.pdfprint') }}`);
            }
            
        });
    </script>
@endsection