<table>
    <thead>
    <tr>
        <th colspan="6" style="text-align: center">{{ $title }}</th>
    </tr>
    <tr>
        <th colspan="6" style="text-align: center">Statement - {{ $date }}</th>
    </tr>
    <tr>
        <th colspan="6" style="text-align: center">Period: {{ request('from') }}
            to {{ request('to') }}</th>
    </tr>
    <tr>
        <th class="w-1 text-center">@lang('S/N')</th>
        <th>@lang('Date')</th>
        <th>@lang('Type')</th>
        <th>@lang('Txnid')</th>
        <th>@lang('Sender')</th>
        <th>@lang('Receiver')</th>
        <th>@lang('Debit')</th>
        <th>@lang('Credit')</th>
        <th>@lang('Charge')</th>
        <th>@lang('Available Balance')</th>
    </tr>
    </thead>
    <tbody>
    @foreach ($transactions as $key=>$data)
        <tr>
            <td class="w-1 text-center" data-label="@lang('No')">
                <div>
                    <span class="text-muted">{{ $loop->iteration }}</span>
                </div>
            </td>

            <td data-label="@lang('Date')">
                <div>
                    {{date('d M Y',strtotime($data->created_at))}}
                </div>
            </td>

            <td data-label="@lang('Type')">
                <div>
                    {{ strtoupper($data->type) }}
                </div>
            </td>

            <td data-label="@lang('Txnid')">
                <div>
                    {{ $data->txnid }}
                </div>
            </td>

            <td data-label="@lang('Sender')">
                <div>
                    {{ $data->sender_user ? $data->sender_user->account_number : '-' }}
                </div>
            </td>

            <td data-label="@lang('Receiver')">
                <div>
                    {{ $data->receiver_user ? $data->receiver_user->account_number : '-' }}
                </div>
            </td>


            <td data-label="@lang('Debit')" class="text-end">
                @if($data->profit !== 'plus')
                    <div>
                        <p class="m-0 text-{{ $data->profit == 'plus' ? 'success' : 'danger'}}">{{ showprice($data->amount,$currency) }}</p>
                    </div>
                @else
                    -
                @endif
            </td>

            <td data-label="@lang('Credit')" class="text-end">
                @if($data->profit == 'plus')
                    <div>
                        <p class="m-0 text-{{ $data->profit == 'plus' ? 'success' : 'danger'}}">{{ showprice($data->amount,$currency) }}</p>
                    </div>
                @else
                    -
                @endif
            </td>

            <td data-label="@lang('Charge')">
                <div>
                    {{ auth()->user()->id == $data->user_id ?  showprice($data->charge, $currency)   : "0.00" }}
                </div>
            </td>

            <td data-label="@lang('Available Balance')">
                <div>
                    {{ auth()->user()->id == $data->user_id ?   strtoupper($data->user_available_balance)  : strtoupper($data->receiver_available_balance) }}
                </div>
            </td>
        </tr>
    @endforeach
    </tbody>
</table>